***  Purpose:  Create work SAS datasets for ASA24 output files.    ***
***  Study type:  Record                                                ***
***  ASA24-2016 Studies created on or after June 1, 2018                           ***;


/***** change thes below four values *****/
/*%let pgmloc = \\westat.com\dfs\ASA24SECONDARY\build\;   *put location of the individual build programs, assumes all in same folder;*/
/*%let csvloc = \\westat.com\dfs\ASA24SECONDARY\build\;   *put location of the individual csv files, assumes all in same folder;*/
/*%let study = Blizz;  *put study name here that matches the prefix of the 5 csv files;*/
/*%let itemsnum = 1613;  *put the number associated with ITEMS csv file here, for example, this value relate to this file radon_2018-10-11_77211_Items;*/


%let pgmloc = H:\ASA24\v2016 sas\Record\;   *put location of the individual build programs, assumes all in same folder;
%let csvloc =H:\ASA24\v2016 data\records\;  *put location of the individual csv files, assumes all in same folder;
%let study = Blizz;  *put study name here that matches the prefix of the 5 csv files;
%let itemsnum = 1613;  *put the number associated with ITEMS csv file here, for example, this value relate to this file radon_2018-10-11_77211_Items;



%let insnum = %sysfunc(sum((&itemsnum*1),1));
%let responsesnum = %sysfunc(sum((&itemsnum*1),2));
%let totalsnum = %sysfunc(sum((&itemsnum*1),3));
%let tnsnum = %sysfunc(sum((&itemsnum*1),4));
%let tsnum = %sysfunc(sum((&itemsnum*1),5));
%put &insnum; %put &responsesnum; %put &totalsnum; %put &tnsnum; %put &tsnum;


*******  there should be no need to modify code below this comment ********;

%let itemsfile = %sysfunc(cats(&csvloc,&study,_,&itemsnum,_items.,csv));
%let insfile = %sysfunc(cats(&csvloc,&study,_,&insnum,_ins.,csv));
%let responsesfile = %sysfunc(cats(&csvloc,&study,_,&responsesnum,_responses.,csv));
%let totalsfile = %sysfunc(cats(&csvloc,&study,_,&totalsnum,_totals.,csv));
%let tnsfile = %sysfunc(cats(&csvloc,&study,_,&tnsnum,_tns.,csv));
%let tsfile = %sysfunc(cats(&csvloc,&study,_,&tsnum,_ts.,csv));
%put &itemsfile; %put &insfile ; %put &responsesfile; %put &totalsfile; %put &tnsfile; %put &tsfile;




%include "&pgmloc.buildresponses_record.sas";
%include "&pgmloc.builditems_record.sas";
%include "&pgmloc.buildtotals_record.sas";
%include "&pgmloc.buildINS_record.sas";
%include "&pgmloc.buildTS_record.sas";
%include "&pgmloc.buildTNS_record.sas";

proc sort data=responses; by username RecordNo RecordDayNo ; run;
proc sort data=items; by username RecordNo RecordDayNo ; run;
proc sort data=totals; by username RecordNo RecordDayNo ; run;
proc sort data=INS; by username RecordNo RecordDayNo ; run;
proc sort data=TS; by username RecordNo RecordDayNo ; run;
proc sort data=TNS; by username RecordNo RecordDayNo ; run;


proc sort data=responses out=responses_one (keep=username RecordNo RecordDayNo ) nodupkey ; by username RecordNo RecordDayNo ; run;
proc sort data=items out=items_one (keep=username RecordNo RecordDayNo  calc) nodupkey ; by username RecordNo RecordDayNo ; run;
proc sort data=totals out=totals_one (keep=username RecordNo RecordDayNo  calc) nodupkey ; by username RecordNo RecordDayNo ; run;
proc sort data=ins out=INS_one (keep=username RecordNo RecordDayNo  calc) nodupkey ; by username RecordNo RecordDayNo ; run;
proc sort data=ts out=TS_one (keep=username RecordNo RecordDayNo  calc) nodupkey ; by username RecordNo RecordDayNo ; run;
proc sort data=tns out=TNS_one (keep=username RecordNo RecordDayNo  calc) nodupkey ; by username RecordNo RecordDayNo ; run;


data chkcounts;
merge responses_one (in=responsesx)
      items_one (in=itemsx drop=calc) totals_one (in=totalsx drop=calc) ins_one (in=insx drop=calc) ts_one (in=tsx drop=calc)
      tns_one (in=tnsx drop=calc);
by username RecordNo RecordDayNo ;
if responsesx then responses=1; else responses=0;
if itemsx then items=1; else items=0;
if totalsx then totals=1; else totals=1;
if insx then ins=1; else ins=0;
if tsx then ts=1; else ts=0;
if tnsx then tns=1; else tns=0;
run;

proc freq data=chkcounts;
tables responses*items*totals*ins*ts*tns /list; run;

