***  Purpose:  Create work SAS datasets for ASA24 output files.    ***
***  Study type:  Record                                                ***
***  ASA24-2018 Studies                           ***;


***** change thes below four values *****;
%let pgmloc = Z:\ASA24MTN\HelpDesk\SASbuildcode\ASA24-2022\Record\;   *put location of the individual build programs, assumes all in same folder;
%let csvloc = Z:\ASA24MTN\Researcher Website\DataDictionaries\ASA242022\Record\;  *put location of the individual csv files, assumes all in same folder;
%let study = curry;  *put study name here that matches the prefix of the 5 csv files;
%let itemsnum = 2022-08-22_51485;  *put the number associated with ITEMS csv file here, for example, this value relate to this file neon_2018-11-06_51988_Items.csv;

*******  there should be no need to modify code below this comment ********;

%let itemsfile = %sysfunc(cats(&csvloc,&study,_,&itemsnum,_items.,csv));
%let insfile = %sysfunc(cats(&csvloc,&study,_,&&itemsnum,_ins.,csv));
%let responsesfile = %sysfunc(cats(&csvloc,&study,_,&itemsnum,_responses.,csv));
%let totalsfile = %sysfunc(cats(&csvloc,&study,_,&itemsnum,_totals.,csv));
%let tnsfile = %sysfunc(cats(&csvloc,&study,_,&itemsnum,_tns.,csv));
%let tsfile = %sysfunc(cats(&csvloc,&study,_,&itemsnum,_ts.,csv));
%put &itemsfile; %put &insfile ; %put &responsesfile; %put &totalsfile; %put &tnsfile; %put &tsfile;

/* CREATES FORMAT CATALOG NEEDED FOR SLEEP ANSWERS AND SAVES IT IN THE SAME LOCATION AS THE CSV FILES */
proc format ;
     invalue xmiss 77777 = .R 99999 = .D ;
    value xmiss 77777 = .R 99999 = .D ;
    invalue xtime 55555 = .S 77777 = .R 99999 = .D other=[time5.] ;
    value xtime 55555 = .S 77777 = .R 99999 = .D other=[time5.] ;
run;
libname xform "&csvloc.";
proc format library = xform.FORMATS ; run ;

%include "&pgmloc.buildresponses_record.sas";
%include "&pgmloc.builditems_record.sas";
%include "&pgmloc.buildtotals_record.sas";
%include "&pgmloc.buildINS_record.sas";
%include "&pgmloc.buildTS_record.sas";
%include "&pgmloc.buildTNS_record.sas";

proc sort data=responses; by username RecordNo RecordDayNo ; run;
proc sort data=items; by username RecordNo RecordDayNo ; run;
proc sort data=totals; by username RecordNo RecordDayNo ; run;
proc sort data=INS; by username RecordNo RecordDayNo ; run;
proc sort data=TS; by username RecordNo RecordDayNo ; run;
proc sort data=TNS; by username RecordNo RecordDayNo ; run;


proc sort data=responses out=responses_one (keep=username RecordNo RecordDayNo ) nodupkey ; by username RecordNo RecordDayNo ; run;
proc sort data=items out=items_one (keep=username RecordNo RecordDayNo  calc) nodupkey ; by username RecordNo RecordDayNo ; run;
proc sort data=totals out=totals_one (keep=username RecordNo RecordDayNo  calc) nodupkey ; by username RecordNo RecordDayNo ; run;
proc sort data=ins out=INS_one (keep=username RecordNo RecordDayNo  calc) nodupkey ; by username RecordNo RecordDayNo ; run;
proc sort data=ts out=TS_one (keep=username RecordNo RecordDayNo  calc) nodupkey ; by username RecordNo RecordDayNo ; run;
proc sort data=tns out=TNS_one (keep=username RecordNo RecordDayNo  calc) nodupkey ; by username RecordNo RecordDayNo ; run;


data chkcounts;
merge responses_one (in=responsesx)
      items_one (in=itemsx drop=calc) totals_one (in=totalsx drop=calc) ins_one (in=insx drop=calc) ts_one (in=tsx drop=calc)
      tns_one (in=tnsx drop=calc);
by username RecordNo RecordDayNo ;
if responsesx then responses=1; else responses=0;
if itemsx then items=1; else items=0;
if totalsx then totals=1; else totals=1;
if insx then ins=1; else ins=0;
if tsx then ts=1; else ts=0;
if tnsx then tns=1; else tns=0;
run;

proc freq data=chkcounts;
tables responses*items*totals*ins*ts*tns /list; run;

