****************************************************************************;
**  Examples using the mixtran and distrib macros saved in the programs     ;
**  mixtran_macro_v1.1.sas						    ;
**  distrib_macro_v1.1.sas						    ;
****************************************************************************;

options linesize=135;

title1 "Example 2 - Model fitting and estimation of the distribution of usual intake for a dietary component that is consumed episodically";
title2 "Using preliminary dataset from public use NHANES data, correlated model, mixtran_macro_v1.1.sas and distrib_macro_v1.1.sas";
title3 "Based on children age 1-8, v_potato, weights, covariates:  sequence, weekend, age group, race, and sex";
/* the libref for the input data */
libname indata "/prj/arb/nhefs/data/userguide/v8";

/* the libref for the output data sets. this libref          */
/* name must be used in the macros, in the parameter outlib= */
libname mylib  "/prj/arb/nhefs/progs/userguide_examples/Example2";

/*  the user must include the programs mixtran_macro_v1.1.sas and distrib_macro_v1.1.sas */
%include "/prj/arb/nhefs/macros4/mixtran_macro_v1.1.sas" ;
%include "/prj/arb/nhefs/macros4/distrib_macro_v1.1.sas" ;
**************************************************************;   


proc format;
value nonzerof
         0 = '0'
    0.000001-1000 = '  > 0 ';
         value agegf
      1 ='  1-3'
      2 ='  4-8'
      3 =' 9-13'
      4 ='14-18'
      5 ='19-30'
      6 ='31-50'
      7 ='51-70'
      8 =' 71+'
      9 =' 19+'
      30=' 9-13'
      40='14-18'
      50='19-30'
      60='31-50'
      70='51-70'
      80=' 71+'
      90=' 19+'
      100='  1+'
      ;

** read in and process the test data;
proc sort data=indata.t_0104nc_may7 out=t_0104nc ;
  by  seqn;
  run;

/* read in data and create dummies of analysis variables ; */
data nhanes;
  set t_0104nc(keep=seqn race rndw rndw1 drxtnumf drddaycd v_potato riagendr ridageyr agegrp stra wkend);
  by seqn ;

  * subset to correct age and sex;
  if agegrp>0; 
  if stra  =1;  /* children*/
    
  r_v_potato= ( v_potato  >0 );
  /* seq2 equals 1 if second day of recall and equals 0 otherwise */
  seq2   = (drddaycd=2); 
  sex    = (riagendr=2);
  weekend= wkend;
  race1  =(race=1);
  race3  =(race=3);
  run;

** preliminary freqs;
proc freq data=nhanes;
  tables race1*race3*race r_v_potato*v_potato seq2*drddaycd agegrp weekend*wkend stra/missing list;
  format v_potato nonzerof. agegrp agegf.;
  title4 'Preliminary frequencies';
  run;

** data set to be used in the macro analysis ;
data  child ;
  set nhanes;
  
  /** As agegrp is the subgroup variable, its components must be included as covariates **/
  agegrp2=(agegrp=2);
  run;
 
/* EXAMPLE 2 */

 /* child data with weight, weekend and subgroup */
 
title4 "Output from the MIXTRAN macro";

%mixtran (data=child,response=v_potato,foodtype=v_potato,subject=seqn,
          repeat=drddaycd,covars_prob=agegrp2 race1 race3 sex,
          covars_amt=agegrp2 race1 race3 sex,
          outlib=mylib,modeltype=corr,lambda=,replicate_var=rndw1,
          seq=seq2,weekend=weekend,vargroup=,numvargroups=,
          subgroup=agegrp,start_val1=,start_val2=, start_val3=,  
          vcontrol=,nloptions=qmax=61,titles=4,printlevel=2);                
run;

title4 "Output from the DISTRIB macro";

%Distrib (seed=5454768, nsim_mc=100,modeltype=corr,                             
          pred=mylib._pred_v_potato, param=mylib._param_v_potato,outlib=mylib,
	  cutpoints= 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0, 
	  ncutpnt=10,
	  byvar=,subgroup=agegrp,subject=seqn,titles=4,food=v_potato);
run;
