****************************************************************************;
**  Examples using the mixtran and distrib macros saved in the programs     ;
**  Example 2 is a correlated model                                         ;
**  mixtran_macro_v2.1.sas		                                  				    ;
**  distrib_macro_v2.1.sas	                                  					    ;
****************************************************************************;

options linesize=135;

title1 "Example 2 - Model fitting and estimation of the distribution of usual intake for a dietary component that is consumed episodically";
title2 "Using data from public use NHANES data, correlated model, mixtran_macro_v2.1.sas and distrib_macro_v2.1.sas";
title3 "Based on children aged 1-8, f_total, weights, covariates:  sequence, weekend, age group, race, and sex";

/* the libref for the input data */
libname indata "&home\NCI_Method\Data";

/* the libref for the output data sets.                                       */
/* this libref name must be used in the macro calls for the parameter outlib= */
libname mylib  "&home\NCI_Method\Examples_v2.1\example2";

/*  the user must include the programs mixtran_macro_v2.1.sas and distrib_macro_v2.1.sas */
%include "&home\NCI_Method\Macros_v2.1\mixtran_macro_v2.1.sas" ;
%include "&home\NCI_Method\Macros_v2.1\distrib_macro_v2.1.sas" ;
**************************************************************;   


proc format;
value nonzerof
         0 = '0'
    0.000001-1000 = '  > 0 ';
         value agegf
      1 ='  1-3'
      2 ='  4-8'
      3 =' 9-13'
      4 ='14-18'
      5 ='19-30'
      6 ='31-50'
      7 ='51-70'
      8 =' 71+'
   -255 = 'Overall'
   ;
value sexfmt
     1= 'Male'
     2 = 'Female'
   ;
     
** read in the data and sort by subject id;
proc sort data=indata.indiv_ims out=nhanes ;
  by  seqn;
  run;

/* read in data and create dummies of analysis variables if not previosuly prepared */
data child;
	set nhanes(keep=seqn race agegrp age2 rndw1 
       day day2 f_total f_total_rec sex sex1 stratum weekend);
  by seqn ;

  ** subset to correct age and sex; 
  if stratum  =1;  /* children aged 1-8 years*/
 
  /* Total Fruit Consumption >0 */
  r_f_total  = ( f_total  >0 );
  
  /* creat dummies of analysis variables */
  race1=(race = 1);
  race3=(race = 3);
  seq2 =(day  = 2); /* seq2 equals 1 if second day of recall and equals 0 otherwise */


    label
      r_f_total = "Fruit consumption greater than 0"
      race1     = "Race: Mexican/American (ref = White)"
      race3     = "Race: Non-Hispanic Black (ref = White)"
      ;   
  run;

/* in this example, the MIXTRAN macro model type will be "corr".                  */

proc freq data=child;
  tables r_f_total*f_total/missing list;
  format f_total nonzerof.;
  title4 'Check zero consumption prior to recoding zero to half the minimum consumption within the MIXTRAN macro';
  run;

** preliminary freqs of covariates;
proc freq data=child;
    tables race*race1*race3  sex*sex1 day*day2 agegrp weekend /missing list;
    format agegrp agegf. sex sexfmt.;
    title4 'Preliminary frequencies of nhanes data';
  run;

** data set to be used in the macro analysis is child ;

  run;
 
/* EXAMPLE 2 */

 /* child data, correlated model, with weekend. */
title4 "Output from the MIXTRAN macro"; 

%mixtran  (data=child,
	        response=f_total,
	        foodtype=f_total_child1,
          subject=seqn,
          repeat=day,
          covars_prob=sex1 age2 race1 race3,
          covars_amt=sex1 age2 race1 race3,
          outlib=mylib,
          modeltype=corr,
          replicate_var=rndw1,
          seq=day2,
          weekend=weekend, 
          nloptions=qmax=61,
          titles=4,
          printlevel=2);                
run;
   
/* execute the DISTRIB macro using the parameter and predicted data sets prepared by the MIXTRAN macro*/
/* a subgroup is used, and subjects meeting or exceeding a recommended amount of intake are flagged   */

title4 "Output from the DISTRIB macro estimating usual intake of any fruit for children";
 
run;
    
   	%Distrib  (call_type=Full,
   	          seed=5454768, 
   	          nsim_mc=100,
            	modeltype=corr,                             
            	pred=mylib._pred_f_total_child1, 
            	param=mylib._param_f_total_child1,
            	outlib=mylib,
  	      	  cutpoints=0.7 1.1 1.6,
  	      	  ncutpnt=3,
    	      	subgroup=agegrp,
    	      	add_da=child, 
    	      	subject=seqn,
    	      	titles=4,
    	      	food=f_total_child,
    	      	mcsimda=mylib._mcsim_f_total_child_rndw1,
  		        recamt=f_total_rec,
  		        recamt_co=ge);
run;

