****************************************************************************;
**  Examples using the mixtran and distrib macros saved in the programs     ;
**  mixtran_macro_v2.1.sas						    ;
**  distrib_macro_v2.1.sas						    ;
****************************************************************************;

options linesize=135;

title1 "Example 3 - Time-saving programming techniques and macro features for a more complicated situation";
title2 "Using preliminary dataset from public use NHANES data, amount-only model, mixtran_macro_v2.1.sas and distrib_macro_v2.1.sas";
title3 "Based on all subjects, add_sug, weights, covariates: sequence, weekend, age group, race, and sex";

/* the libref for the input data */
libname indata "&home\NCI_Method\Data";

/* the libref for the output data sets.                                  */
/* this libref name must be used in the macros, if data are to be saved, in the parameter outlib= */
libname mylib  "&home\NCI_Method\Examples_v2.1\example3";

/*  the user must include the programs mixtran_macro_v2.1.sas and distrib_macro_v2.1.sas */
%include "&home\NCI_Method\Macros_v2.1\mixtran_macro_v2.1.sas" ;
%include "&home\NCI_Method\Macros_v2.1\distrib_macro_v2.1.sas" ;
**************************************************************;   


proc format;
value nonzerof
                0 = ' 0'
    0.000001-high = ' > 0';
value agegf
        1 ='age 2-3'
        2 ='age 4-8'
        3 ='9-13 M'
        4 ='14-18 M'
        5 ='19-30 M'
        6 ='31-50 M'
        7 ='51-70 M'
        8 ='71+ M'
        30='9-13 F'
        40='14-18 F'
        50='19-30 F'
        60='31-50 F'
        70='51-70 F'
        80='71+ F'
      -255='2+'
        ;   
    value sexfmt
     1= 'Male'
     2 = 'Female'
     ;
      

** read in the data and sort by subject id;
proc sort data=indata.indiv_ims out=nhanes ;
  by  seqn;
  run;

/* read in data and create dummies of analysis variables if not previosuly prepared */
data nhanes;
	set nhanes(keep=seqn race agegrp age2 age4-age8 rndw1 
       day day2 add_sug add_sug_rec sex sex1 stratum weekend);
  by seqn ;

  r_add_sug  = ( add_sug  >0 );
  
  /* creat dummies of analysis variables */
  race1=(race = 1);
  race3=(race = 3);
  seq2 =(day  = 2 ); /* seq2 equals 1 if second day of recall and otherwise equals 0 */
  
  /* for use in the DISTRIB macro the subgroup 'agegroup' should differentiate between males and females 9+ years old */
      if stratum =3 then agegroup=agegrp*10;
      else agegroup=agegrp;
  


    label
      r_add_sug = "Ever/Never consumed added sugars"
      race1     = "Race: Mexican/American (ref = White)"
      race3     = "Race: Non-Hispanic Black (ref = White)"
      ;   
  run;

/* in this example, the MIXTRAN macro model type will be "amount".  */

proc freq data=nhanes;
  tables r_add_sug*add_sug/missing list;
  format add_sug nonzerof.;
  title4 'Check zero consumption prior to recoding zero to half the minimum consumption within the MIXTRAN macro';
  run;

** preliminary freqs;
proc freq data=nhanes;
    tables race*race1*race3  day*day2 agegrp weekend /missing list;
    format agegrp agegf.;
    title4 'Preliminary frequencies of nhanes data';
  run;

  ** data sets to be used in the macro analysis ;
  data child male feml;
    set nhanes;
  
      if stratum=1 then output child;
      if stratum=2 then output male;
      if stratum=3 then output feml;
         
    run;
 
/* EXAMPLE 3 */

 /* child data with weight, weekend */
title4 "Output from the MIXTRAN macro for add_sug children aged <9"; 

%mixtran  (data=child,
	        response=add_sug,
	        foodtype=add_sug_child1,
          subject=seqn,
          repeat=day,
          covars_prob=,
          covars_amt=sex1 age2 race1 race3,
          outlib=mylib,
          modeltype=amount,
          lambda=,
          replicate_var=rndw1,
          seq=day2,
          weekend=weekend,
          vargroup=,numvargroups=,
          start_val1=,start_val2=, start_val3=,vcontrol=,  
          nloptions=qmax=61,
          titles=4,
          printlevel=2);                
run;

 /* male data with weight, weekend and subgroup */
title4 "Output from the MIXTRAN macro for add_sug males 9+"; 

%mixtran  (data=male,
	        response=add_sug,
	        foodtype=add_sug_male1,
          subject=seqn,
          repeat=day,
          covars_prob=,
          covars_amt=age4 age5 age6 age7 age8 race1 race3,
          outlib=mylib,
          modeltype=amount,
          lambda=,
          replicate_var=rndw1,
          seq=day2,
          weekend=weekend,
          vargroup=,numvargroups=,
          start_val1=,start_val2=, start_val3=,vcontrol=,  
          nloptions=qmax=61,
          titles=4,
          printlevel=2);                
run;

 /* female data with weight, weekend and subgroup */
title4 "Output from the MIXTRAN macro for add_sug females 9+"; 

%mixtran  (data=feml,
	        response=add_sug,
	        foodtype=add_sug_feml1,
          subject=seqn,
          repeat=day,
          covars_prob=,
          covars_amt=age4 age5 age6 age7 age8 race1 race3,
          outlib=mylib,
          modeltype=amount,
          lambda=,
          replicate_var=rndw1,
          seq=day2,
          weekend=weekend,
          vargroup=,numvargroups=,
          start_val1=,start_val2=, start_val3=,vcontrol=,  
          nloptions=qmax=61,
          titles=4,
          printlevel=2);                
run;
    
*********************************************************************************************************;

/* concatenate the data from MIXTRAN to get distributions from DISTRIB for each sub-population in one call */
/* Estimtes are calculated for each subject, based on the sub-population predicted values and parameters   */

data _pred_unc_add_sug_all;
  set mylib._pred_unc_add_sug_child1 (in=in1)
      mylib._pred_unc_add_sug_male1  (in=in2)
      mylib._pred_unc_add_sug_feml1  (in=in3);

       if (in1) then stra = 1;
  else if (in2) then stra = 2;
  else if (in3) then stra = 3;
  run;

data _param_unc_add_sug_all;
  set mylib._param_unc_add_sug_child1 (in=in1)
      mylib._param_unc_add_sug_male1  (in=in2)
      mylib._param_unc_add_sug_feml1  (in=in3);

       if (in1) then stra = 1;
  else if (in2) then stra = 2;
  else if (in3) then stra = 3;
  run;


 /* all by-groups combined. */

  ************************************* Note on Changes from version 1.1 **********************************************
  ** set the paramter 'call_type' to Full, to create  both the usual intake estimates and the distributions.         **
  ** to get the percentage not meeting the recommended amount use the parameters rec_amt and recamt_co.              **
  ** to weight the weekend variable other than 4/7 & 3/7 set the wkend_prop parameter to the weight for the weekend. **
  **   In this example 3/7 was used as a demonstration, even though the default is 3/7).                      **
  ;
title4 "Output from the DISTRIB macro for combined sex and age groups";
run;
    
   	%Distrib  (call_type=Full,
   	          seed=5454768, 
   	          nsim_mc=100,
            	modeltype=amount,                             
            	pred=_pred_unc_add_sug_all, 
            	param=_param_unc_add_sug_all,
            	outlib=mylib,
  	      	  cutpoints= 10 12 14 17 22 25 33 38 42 47,
  	      	  ncutpnt=10,
    	      	subgroup=agegroup,
    	      	add_da=nhanes, 
    	      	byvar=stra,       /* this ensures the appropriate prameters and predicted values for each sub-population are used */
    	      	subject=seqn,
    	      	titles=4,
    	      	food=add_sug,
    	      	mcsimda=mylib._mcsim_add_sug_rndw1,
  		        recamt=add_sug_rec,
  		        recamt_co=lt,
  		        recamt_hi=,
  		        wkend_prop=3/7 );
run;

/************************************************************************************/

/* this next step shows how to re-use the data from MIXTRAN in the DISTRIB macro */

  /* get distributions for males aged 19+ */
  

data _pred_unc_add_sug_m19 ;         
  merge 
    mylib._pred_unc_add_sug_male1 (in=pred)
    male (keep=seqn agegroup);
    by seqn;
    
  if pred ;
  if agegroup in (5 6 7 8 ) ;
  
  stra=2;
  drop agegroup ;
  run;

data _param_unc_add_sug_m19 ;         
  set mylib._param_unc_add_sug_male1 ;
  stra=2 ;
  run;
 
title4 "Output from the DISTRIB macro for males aged 19+";
run;   

  ** Note the call_type parameter is PC, which uses the previously calculated intake estimates   **
  ** to prepare new distributions.    **;
  
    	%Distrib  (call_type=PC,
            	modeltype=amount,                             
            	pred=_pred_unc_add_sug_m19, 
            	param=_param_unc_add_sug_m19,
            	outlib=mylib,
  	      	  cutpoints= 10 12 14 17 22 25 33 38 42 47,
  	      	  ncutpnt=10,
    	      	add_da=male, 
    	      	byvar=stra,
    	      	subject=seqn,
    	      	titles=4,
    	      	food=add_sug_m19,
    	      	mcsimda=mylib._mcsim_add_sug_rndw1,
  		        recamt=add_sug_rec,
  		        recamt_co=lt);


 
  /* get distributions for females aged 19+ */
data _pred_unc_add_sug_f19 ;         
  merge 
    mylib._pred_unc_add_sug_feml1 (in=pred)
    feml (keep=seqn agegroup);
    by seqn ;
    
  if pred ;
  if agegroup in (50 60 70 80 ) ;
  
  stra=3;
  drop agegroup;
  run;

data _param_unc_add_sug_f19 ;         
  set mylib._param_unc_add_sug_feml1 ;
  stra=3 ;
  run;  

title4 "Output from the DISTRIB macro for females age 19+";
run;   
    	%Distrib  (call_type=PC,
            	modeltype=amount,                             
            	pred=_pred_unc_add_sug_f19, 
            	param=_param_unc_add_sug_f19,
            	outlib=mylib,
  	      	  cutpoints= 10 12 14 17 22 25 33 38 42 47,
  	      	  ncutpnt=10,
    	      	add_da=feml, 
    	      	byvar=stra,
    	      	subject=seqn,
    	      	titles=4,
    	      	food=add_sug_f19,
    	      	mcsimda=mylib._mcsim_add_sug_rndw1,
  		        recamt=add_sug_rec,
  		        recamt_co=lt) ;


run;    
