/*

DSQ Self-Administered Questionnaire: Paper 

SAS program to process self-administered paper questionnaire  

*/



 

filename yourdata '**insert file name for data**';





/*

  The following files are contained within the archive that 

  contained this analysis program.  Once extracted from the archive, 

  these files should be located in the same folder/directory as 

  the analysis program.

*/  



  libname ntile xlsx '..calib.DSQ.cereal.ntile.xlsx'; 

  libname psize xlsx '..calib.portion.size.xlsx';

  libname rcoeff xlsx '..calib.equation.coeff.xlsx'; 





proc format;  

  value gender 1='male'

               2='female';



run;



data dtq;

  set yourdata;



/*this program uses variables names:

    DSQ_xx1

    DSQ_xx2

    DSQ_010, DSQ_030, etc



 ***PLEASE NOTE SPECIAL CEREAL RECODING IS REQUIRED BEFORE RUNNING THIS CODE****



 DSQ_020 and DSQ_xx3 MUST be converted to an 8 digit foodcode by the user



 The current variables (DSQ_020 and DSQ_xx3) are character variables that represent

 assorted cereals.  Using the 'calib.DSQ.cereal.ntile.xlsx' file, the user

 must create new variables, which will be called:



   food_code_1 and

   food_code_2



 and contain an eight digit FNDDS foodcode which represents the particular cereal

 that was reported.  If only one cereal is reported,  food_code_2 should remain blank.



*/



/*in this data step, create variables: 

  Required names include: ageinyr (age in years) gender (1=male 2=female)  

  and the food ffq - each food has two variables, times and units 

*/



  ageinyr=DSQ_xx1;

  if DSQ_xx2='A' then gender=1;			

    else if DSQ_xx2='B' then gender=2;



  cereal1fc=food_code_1;

  cereal2fc=food_code_2;



/*create numcer to represent the number of cereals provided;

*/



  if cereal1fc=. and cereal2fc=. then numcer=0;

    else if cereal1fc > 0 and cereal2fc > 0 then numcer=2;

    else if cereal1fc > 0 then numcer=1;





/*converting responses into times per day for food variables of interest;

*/



 %macro foodrange (in,out,maxv);

 if &in='A' then &out=0;

   else if &in='B' then &out=0.033;

   else if &in='C' then &out=0.083;

   else if &in='D' then &out=0.143;

   else if &in='E' then &out=0.286;

   else if &in='F' then &out=0.5;

   else if &in='G' then &out=0.786;

   else if &in='H' then &out=1;

   else if &in='I' then &out=2;

    *top code outliers;

   if &out > &maxv then &out=&maxv;    

%mend foodrange;



%macro bevrange (in,out,maxv);

 if &in='A' then &out=0;

   else if &in='B' then &out=0.033;

   else if &in='C' then &out=0.083;

   else if &in='D' then &out=0.143;

   else if &in='E' then &out=0.286;

   else if &in='F' then &out=0.5;

   else if &in='G' then &out=0.786;

   else if &in='H' then &out=1;

   else if &in='I' then &out=2.5;

   else if &in='J' then &out=4.5;

   else if &in='K' then &out=6;

    *top code outliers;

   if &out > &maxv then &out=&maxv;  

%mend bevrange;



  %foodrange(dsq_010,hccerxpd,7);

  %bevrange(dsq_030,milkxpd,10);

  %bevrange(dsq_040,sodaxpd,8);

  %bevrange(dsq_050,frtjcxpd,8);

  %bevrange(dsq_060,swtctxpd,10);

  %bevrange(dsq_070,energyxpd,7);

  %foodrange(dsq_080,fruitxpd,8);

  %foodrange(dsq_090,saladxpd,5);

  %foodrange(dsq_100,frfryxpd,5);

  %foodrange(dsq_110,othpotxpd,3);

  %foodrange(dsq_120,beanxpd,4);

  %foodrange(dsq_130,othvegxpd,5);

  %foodrange(dsq_140,pizzaxpd,2);

  %foodrange(dsq_150,salsaxpd,3);

  %foodrange(dsq_160,tomscxpd,2);

  %foodrange(dsq_190,cheesexpd,6);

  %foodrange(dsq_200,whgbrdxpd,6);

  %foodrange(dsq_210,brricexpd,4);

  %foodrange(dsq_220,candyxpd,8);

  %foodrange(dsq_230,donutxpd,5);

  %foodrange(dsq_240,cakexpd,7);

  %foodrange(dsq_250,icecrmxpd,5);

  %foodrange(dsq_260,popcornxpd,3);



  label hccerxpd='number of times per day eat hot or cold cereal'
        milkxpd='number of times per day drink milk'
	sodaxpd='number of times per day drink soda'
	frtjcxpd='number of times per day drink fruit juice'
	swtctxpd='number of times per day drink sweet coffee/tea'
	energyxpd='number of times per day drink fruit/sports/energy drink'
	fruitxpd='number of times per day eat fruit'
	saladxpd='number of times per day eat salad'
	frfryxpd='number of times per day eat fried potatoes'
	othpotxpd='number of times per day eat other potatoes'
	beanxpd='number of times per day eat beans'
	othvegxpd='number of times per day eat other vegetables'
	pizzaxpd='number of times per day eat pizza'
	salsaxpd='number of times per day eat salsa'
	tomscxpd='number of times per day eat tomtato sauce'
	cheesexpd='number of times per day eat cheese'
	whgbrdxpd='number of times per day eat whole grain bread'
	brricexpd='number of times per day eat cooked whole grain (brown rice)'
	candyxpd='number of times per day eat candy'
	donutxpd='number of times per day eat pastries'
	cakexpd='number of times per day eat cookies/cake'
	icecrmxpd='number of times per day eat ice cream'
	popcornxpd='number of times per day eat pop corn';

   if (2 <= ageinyr <= 3) then bcage=1;
    else if (4 <= ageinyr <= 5) then bcage=2;
    else if (6 <= ageinyr <= 7) then bcage=3;
    else if (8 <= ageinyr <= 9) then bcage=4;
    else if (10 <= ageinyr <= 11) then bcage=5;
    else if (12 <= ageinyr <= 13) then bcage=6;
    else if (14 <= ageinyr <= 15) then bcage=7;
    else if (16 <= ageinyr <= 17) then bcage=8;
    else if (18 <= ageinyr <= 25) then bcage=9;
    else if (26 <= ageinyr <= 35) then bcage=10;
    else if (36 <= ageinyr <= 45) then bcage=11;
    else if (46 <= ageinyr <= 60) then bcage=12;
    else if (61 <= ageinyr <= 69) then bcage=13;
    else if (70 <= ageinyr <= 99) then bcage=14;

    *make age dummy variables ****;

    if (2 <= ageinyr <= 11) then kidgrp=1;
      else kidgrp=0;
    if (12 <= ageinyr <= 17) then teengrp=1;
      else teengrp=0;

run;

data ntile;
  set ntile.'CALIB.DSQ.CEREAL.NTILE'n;
run;	 	 

proc sort data=ntile;
  by food_code;
run;

data ntile (keep=cereal1fc cereal2fc whgnt sugnt calcnt fibnt);
  set ntile;
  by food_code;
  if first.food_code;
  cereal1fc=food_code;
  cereal2fc=food_code;
run;
  
proc sort data=dtq;
  by cereal1fc;
run;

proc sort data=ntile;
  by cereal1fc;
run;

data dtq (drop= whgnt sugnt calcnt fibnt);
  merge dtq (in=d) ntile (drop=cereal2fc);
  by cereal1fc;
  if d;

  c1whgnt=whgnt;
  c1sugnt=sugnt;
  c1calcnt=calcnt;
  c1fibnt=fibnt;
run;

proc sort data=dtq;
  by cereal2fc;
run;

proc sort data=ntile;
  by cereal2fc;
run;

data dtq (drop= whgnt sugnt calcnt fibnt);
  merge dtq (in=d) ntile (drop=cereal1fc);
  by cereal2fc;
  if d;

  c2whgnt=whgnt;
  c2sugnt=sugnt;
  c2calcnt=calcnt;
  c2fibnt=fibnt;
run;

data dtq;
  set dtq;

  if numcer in (0,1,2) and hccerxpd >= 0 then do;
   wg1f=0; wg2f=0; wg3f=0; 
   as1f=0; as2f=0; as3f=0;
   cm1f=0; cm2f=0; cm3f=0; 
   fb1f=0; fb2f=0; fb3f=0;
  if numcer=1 then do;
    if c1whgnt=1 then wg1f=wg1f+hccerxpd;
      else if c1whgnt=2 then wg2f=wg2f+hccerxpd;
      else if c1whgnt=3 then wg3f=wg3f+hccerxpd;
    if c1sugnt=1 then as1f=as1f+hccerxpd;
      else if c1sugnt=2 then as2f=as2f+hccerxpd;
      else if c1sugnt=3 then as3f=as3f+hccerxpd;
    if c1calcnt=1 then cm1f=cm1f+hccerxpd;
      else if c1calcnt=2 then cm2f=cm2f+hccerxpd;
      else if c1calcnt=3 then cm3f=cm3f+hccerxpd;
    if c1fibnt=1 then fb1f=fb1f+hccerxpd;
      else if c1fibnt=2 then fb2f=fb2f+hccerxpd;
      else if c1fibnt=3 then fb3f=fb3f+hccerxpd;;
   end;
   else if numcer=2 then do;
    if c1whgnt=1 then wg1f=wg1f+(.75*hccerxpd);
      else if c1whgnt=2 then wg2f=wg2f+(.75*hccerxpd);
      else if c1whgnt=3 then wg3f=wg3f+(.75*hccerxpd);
    if c2whgnt=1 then wg1f=wg1f+(.25*hccerxpd);
      else if c2whgnt=2 then wg2f=wg2f+(.25*hccerxpd);
      else if c2whgnt=3 then wg3f=wg3f+(.25*hccerxpd);
    if c1sugnt=1 then as1f=as1f+(.75*hccerxpd);
      else if c1sugnt=2 then as2f=as2f+(.75*hccerxpd);
      else if c1sugnt=3 then as3f=as3f+(.75*hccerxpd);
    if c2sugnt=1 then as1f=as1f+(.25*hccerxpd);
      else if c2sugnt=2 then as2f=as2f+(.25*hccerxpd);
      else if c2sugnt=3 then as3f=as3f+(.25*hccerxpd);
    if c1calcnt=1 then cm1f=cm1f+(.75*hccerxpd);
      else if c1calcnt=2 then cm2f=cm2f+(.75*hccerxpd);
      else if c1calcnt=3 then cm3f=cm3f+(.75*hccerxpd);
    if c2calcnt=1 then cm1f=cm1f+(.25*hccerxpd);
      else if c2calcnt=2 then cm2f=cm2f+(.25*hccerxpd);
      else if c2calcnt=3 then cm3f=cm3f+(.25*hccerxpd);
    if c1fibnt=1 then fb1f=fb1f+(.75*hccerxpd);
      else if c1fibnt=2 then fb2f=fb2f+(.75*hccerxpd);
      else if c1fibnt=3 then fb3f=fb3f+(.75*hccerxpd);
    if c2fibnt=1 then fb1f=fb1f+(.25*hccerxpd);
      else if c2fibnt=2 then fb2f=fb2f+(.25*hccerxpd);
      else if c2fibnt=3 then fb3f=fb3f+(.25*hccerxpd);
    end;
   end;
run;

proc sort data=dtq;
  by gender bcage;
run;

*this pulls in the portion size adjustment information by gender and agegrp;
data adjps;
  set psize.'CALIB.PORTION.SIZE'n;
  bcage=agegrp;
run;
	 

proc sort data=adjps;
  by gender bcage;
run;

*merge analysis data with portion size adjustment data;
data dtq;
  merge dtq (in=d) adjps;
  by gender bcage;
  if d;
run;

data dtq;
  set dtq;
  by gender;

 *make psize adj freq vars;
  gfb1f=fb1f*gadj25;
  gfb2f=fb2f*gadj26;
  gfb3f=fb3f*gadj27;
  gmilk=milkxpd*gadj3;
  gsoda=sodaxpd*gadj4;
  gfrtjc=frtjcxpd*gadj5;
  gswtct=swtctxpd*gadj6;
  genergy=energyxpd*gadj7;
  gfruit=fruitxpd*gadj8;
  gsalad=saladxpd*gadj9;
  gfrfry=frfryxpd*gadj10;
  gothpot=othpotxpd*gadj11;
  gbean=beanxpd*gadj12;
  gothveg=othvegxpd*gadj13;
  gpizza=pizzaxpd*gadj14;
  gsalsa=salsaxpd*gadj15;
  gtomsc=tomscxpd*gadj16;
  gcheese=cheesexpd*gadj17;
  gwhgbrd=whgbrdxpd*gadj18;
  gbrrice=brricexpd*gadj19;
  gcandy=candyxpd*gadj20;
  gdonut=donutxpd*gadj21;
  gcake=cakexpd*gadj22;
  gicecrm=icecrmxpd*gadj23;
  gpopcorn=popcornxpd*gadj24;

  *calcium;
  gcm1f=cm1f*gadj28;
  gcm2f=cm2f*gadj29;
  gcm3f=cm3f*gadj30;

  *for whole grain;
  gwg1f=wg1f*gadj34;
  gwg2f=wg2f*gadj35;
  gwg3f=wg3f*gadj36;

  *for dairy;
  dmilk=milkxpd*dadj3;
  dcheese=cheesexpd*dadj17;
  dpizza=pizzaxpd*dadj14;
  dicecrm=icecrmxpd*dadj23;


  *for sugar/ssb;
  sas1f=as1f*sadj31;
  sas2f=as2f*sadj32;
  sas3f=as3f*sadj33;
  sicecrm=icecrmxpd*sadj23;
  scake=cakexpd*sadj22;
  ssoda=sodaxpd*sadj4;
  sswtct=swtctxpd*sadj6;
  senergy=energyxpd*sadj7;
  scandy=candyxpd*sadj20;
  sdonut=donutxpd*sadj21;


  *for fruit;
  ffrtjc=frtjcxpd*fadj5;
  ffruit=fruitxpd*fadj8;


  *for veg;
  vsalad=saladxpd*vadj9;
  vfrfry=frfryxpd*vadj10;
  vothpot=othpotxpd*vadj11;
  vbean=beanxpd*vadj12;
  vothveg=othvegxpd*vadj13;
  vpizza=pizzaxpd*vadj14;
  vsalsa=salsaxpd*vadj15;
  vtomsc=tomscxpd*vadj16;

  *for tot frt/veg;
  pfrtjc=frtjcxpd*padj5;
  pfruit=fruitxpd*padj8;
  psalad=saladxpd*padj9;
  pfrfry=frfryxpd*padj10;
  pothpot=othpotxpd*padj11;
  pbean=beanxpd*padj12;
  pothveg=othvegxpd*padj13;
  ppizza=pizzaxpd*padj14;
  psalsa=salsaxpd*padj15;
  ptomsc=tomscxpd*padj16;


run;


*this pulls in the intercept and beta coefficient information by gender;

data betaint;
  set rcoeff.'CALIB.EQUATION.COEFF'n;
run;

proc sort data=betaint;
  by gender;
run;

*merge analysis data with intercept and beta coefficient data;
data mdtq;
  merge dtq (in=d) betaint;
  by gender;
  if d;
run;

*create predicted variables;
data mdtq;
  set mdtq;
  by gender;

  DSQfib=mfintercept +  (kidgrp*mfkidb) + (teengrp*mfteenb)  + (gfb1f*mfcer1b) + (gfb2f*mfcer2b) + (gfb3f*mfcer3b) + (gwhgbrd*mfwgbb) + (gbrrice*mfbrricb) + 
     (gcheese*mfcheesb) +  (gpizza*mfpizzab) +  (gmilk*mfmilkb) +  (gicecrm*mficecrb) +  (gpopcorn*mfpcornb) + 
     (gsoda*mfsodab) +  (genergy*mfspdrb) +  (gcake*mfcakeb) +  (gdonut*mfdonutb) +  (gswtct*mfswctb) +  (gcandy*mfcandyb) + 
     (gfrtjc*mffjcb) +  (gfruit*mffruitb)  +  (gsalad*mfsaladb) + (gothpot*mfothptb) +  (gbean*mfbeanb) +
     (gothveg*mfothvgb) +  (gfrfry*mffrfrb) +  (gtomsc*mftomscb) +  (gsalsa*mfsalsab) ;

  DSQcalc=mcintercept +  (kidgrp*mckidb) + (teengrp*mcteenb)  + (gcm1f*mccer1b) + (gcm2f*mccer2b) + (gcm3f*mccer3b) + (gwhgbrd*mcwgbb) + (gbrrice*mcbrricb) + 
     (gcheese*mccheesb) +  (gpizza*mcpizzab) +  (gmilk*mcmilkb) +  (gicecrm*mcicecrb) +  (gpopcorn*mcpcornb) + 
     (gsoda*mcsodab) +  (genergy*mcspdrb) +  (gcake*mccakeb) +  (gdonut*mcdonutb) +  (gswtct*mcswctb) +  (gcandy*mccandyb) + 
     (gfrtjc*mcfjcb) +  (gfruit*mcfruitb)  +  (gsalad*mcsaladb) + (gothpot*mcothptb) +  (gbean*mcbeanb) +
     (gothveg*mcothvgb) +  (gfrfry*mcfrfrb) +  (gtomsc*mctomscb) +  (gsalsa*mcsalsab) ;

  DSQwhgr=mgintercept +  (kidgrp*mgkidb) + (teengrp*mgteenb)  + (gwg1f*mgcer1b) + (gwg2f*mgcer2b) + (gwg3f*mgcer3b) + (gwhgbrd*mgwgbb) + (gbrrice*mgbrricb) + 
      (gpopcorn*mgpcornb)  ;

  DSQsug=msintercept +  (kidgrp*mskidb) + (teengrp*msteenb)  + (sas1f*mscer1b) + (sas2f*mscer2b) + (sas3f*mscer3b) +  
     (sicecrm*msicecrb) +  (ssoda*mssodab) +  (senergy*msspdrb) +  (scake*mscakeb) +  (sdonut*msdonutb) +  (sswtct*msswctb) +  (scandy*mscandyb) ;

  DSQdairy=mdintercept +   (kidgrp*mdkidb) + (teengrp*mdteenb)  + (dcheese*mdcheesb) +  (dpizza*mdpizzab) +  (dmilk*mdmilkb) +  (dicecrm*mdicecrb)  ;

  DSQfvl=mpintercept +   (kidgrp*mpkidb) + (teengrp*mpteenb) +  
     (pfrtjc*mpfjcb) +  (pfruit*mpfruitb)  +  (psalad*mpsaladb) + (pothpot*mpothptb) +  (pbean*mpbeanb) +
     (pothveg*mpothvgb) +  (pfrfry*mpfrfrb) +  (ptomsc*mptomscb) +  (psalsa*mpsalsab) +  (ppizza*mppizzab) ;

  DSQvlall=mvintercept +   (kidgrp*mvkidb) + (teengrp*mvteenb) +  
     (vsalad*mvsaladb) + (vothpot*mvothptb) +  (vbean*mvbeanb) +  (vpizza*mvpizzab) +
     (vothveg*mvothvgb) +  (vfrfry*mvfrfrb) +  (vtomsc*mvtomscb) +  (vsalsa*mvsalsab) ;

  DSQfvlnf=mnintercept +   (kidgrp*mnkidb) + (teengrp*mnteenb) +  
     (pfrtjc*mnfjcb) +  (pfruit*mnfruitb)  +  (psalad*mnsaladb) + (pothpot*mnothptb) +  (pbean*mnbeanb) +
     (pothveg*mnothvgb) +  (ptomsc*mntomscb) +  (psalsa*mnsalsab) + (ppizza*mnpizzab) ;

  DSQvlnf=muintercept +   (kidgrp*mukidb) + (teengrp*muteenb) +  
     (vsalad*musaladb) + (vothpot*muothptb) +  (vbean*mubeanb) +  (vpizza*mupizzab) +
     (vothveg*muothvgb) +  (vtomsc*mutomscb) +  (vsalsa*musalsab) ;

  DSQfrt=mrintercept +   (kidgrp*mrkidb) + (teengrp*mrteenb)  + (ffrtjc*mrfjcb) +  (ffruit*mrfruitb)  ;

  DSQssb=mxintercept +  (kidgrp*mxkidb) + (teengrp*mxteenb) +  (ssoda*mxsodab) +  (senergy*mxspdrb) + (sswtct*mxswctb)  ;

label  DSQfvl = 'Predicted intake of fruits and vegetables including legumes and French fries (cup equivalents) per day'
 DSQfvlnf = 'Predicted intake of fruits and vegetables including legumes and excluding French fries (cup equivalents) per day'
 DSQfrt = 'Predicted intake of fruits (cup equivalents) per day'
 DSQvlall = 'Predicted intake of vegetables including legumes and French fries (cup equivalents) per day'
 DSQvlnf = 'Predicted intake of vegetables including legumes and excluding French fries (cup equivalents) per day'
 DSQdairy = 'Predicted intake of dairy (cup equivalents) per day'
 DSQsug = 'Predicted intake of total added sugars (tsp equivalents) per day' 
 DSQssb = 'Predicted intake of added sugars from sugar-sweetened beverages (tsp equivalents) per day'
 DSQwhgr = 'Predicted intake of whole grains (ounce equivalents) per day'
 DSQfib = 'Predicted intake of fiber (gm) per day'
 DSQcalc = 'Predicted intake of calcium (mg) per day';

  *set neg to zero;
  array mpred DSQfib--DSQssb;
  do over mpred;
    if mpred ne . and mpred < 0 then mpred=0;
  end;

  DSQfib_low=lfintercept +  (kidgrp*lfkidb) + (teengrp*lfteenb)  + (gfb1f*lfcer1b) + (gfb2f*lfcer2b) + (gfb3f*lfcer3b) + (gwhgbrd*lfwgbb) + (gbrrice*lfbrricb) + 
     (gcheese*lfcheesb) +  (gpizza*lfpizzab) +  (gmilk*lfmilkb) +  (gicecrm*lficecrb) +  (gpopcorn*lfpcornb) + 
     (gsoda*lfsodab) +  (genergy*lfspdrb) +  (gcake*lfcakeb) +  (gdonut*lfdonutb) +  (gswtct*lfswctb) +  (gcandy*lfcandyb) + 
     (gfrtjc*lffjcb) +  (gfruit*lffruitb)  +  (gsalad*lfsaladb) + (gothpot*lfothptb) +  (gbean*lfbeanb) +
     (gothveg*lfothvgb) +  (gfrfry*lffrfrb) +  (gtomsc*lftomscb) +  (gsalsa*lfsalsab) ;

  DSQcalc_low=lcintercept +  (kidgrp*lckidb) + (teengrp*lcteenb)  + (gcm1f*lccer1b) + (gcm2f*lccer2b) + (gcm3f*lccer3b) + (gwhgbrd*lcwgbb) + (gbrrice*lcbrricb) + 
     (gcheese*lccheesb) +  (gpizza*lcpizzab) +  (gmilk*lcmilkb) +  (gicecrm*lcicecrb) +  (gpopcorn*lcpcornb) + 
     (gsoda*lcsodab) +  (genergy*lcspdrb) +  (gcake*lccakeb) +  (gdonut*lcdonutb) +  (gswtct*lcswctb) +  (gcandy*lccandyb) + 
     (gfrtjc*lcfjcb) +  (gfruit*lcfruitb)  +  (gsalad*lcsaladb) + (gothpot*lcothptb) +  (gbean*lcbeanb) +
     (gothveg*lcothvgb) +  (gfrfry*lcfrfrb) +  (gtomsc*lctomscb) +  (gsalsa*lcsalsab) ;

  DSQwhgr_low=lgintercept +  (kidgrp*lgkidb) + (teengrp*lgteenb)  + (gwg1f*lgcer1b) + (gwg2f*lgcer2b) + (gwg3f*lgcer3b) + (gwhgbrd*lgwgbb) + (gbrrice*lgbrricb) + 
      (gpopcorn*lgpcornb)  ;

  DSQsug_low=lsintercept +  (kidgrp*lskidb) + (teengrp*lsteenb)  + (sas1f*lscer1b) + (sas2f*lscer2b) + (sas3f*lscer3b) +  
     (sicecrm*lsicecrb) +  (ssoda*lssodab) +  (senergy*lsspdrb) +  (scake*lscakeb) +  (sdonut*lsdonutb) +  (sswtct*lsswctb) +  (scandy*lscandyb) ;

  DSQdairy_low=ldintercept +   (kidgrp*ldkidb) + (teengrp*ldteenb)  + (dcheese*ldcheesb) +  (dpizza*ldpizzab) +  (dmilk*ldmilkb) +  (dicecrm*ldicecrb)  ;

  DSQfvl_low=lpintercept +   (kidgrp*lpkidb) + (teengrp*lpteenb) +  
     (pfrtjc*lpfjcb) +  (pfruit*lpfruitb)  +  (psalad*lpsaladb) + (pothpot*lpothptb) +  (pbean*lpbeanb) +
     (pothveg*lpothvgb) +  (pfrfry*lpfrfrb) +  (ptomsc*lptomscb) +  (psalsa*lpsalsab) +  (ppizza*lppizzab) ;

  DSQvlall_low=lvintercept +   (kidgrp*lvkidb) + (teengrp*lvteenb) +  
     (vsalad*lvsaladb) + (vothpot*lvothptb) +  (vbean*lvbeanb) +  (vpizza*lvpizzab) +
     (vothveg*lvothvgb) +  (vfrfry*lvfrfrb) +  (vtomsc*lvtomscb) +  (vsalsa*lvsalsab) ;

  DSQfvlnf_low=lnintercept +   (kidgrp*lnkidb) + (teengrp*lnteenb) +  
     (pfrtjc*lnfjcb) +  (pfruit*lnfruitb)  +  (psalad*lnsaladb) + (pothpot*lnothptb) +  (pbean*lnbeanb) +
     (pothveg*lnothvgb) +  (ptomsc*lntomscb) +  (psalsa*lnsalsab) + (ppizza*lnpizzab) ;

  DSQvlnf_low=luintercept +   (kidgrp*lukidb) + (teengrp*luteenb) +  
     (vsalad*lusaladb) + (vothpot*luothptb) +  (vbean*lubeanb) +  (vpizza*lupizzab) +
     (vothveg*luothvgb) +  (vtomsc*lutomscb) +  (vsalsa*lusalsab) ;

  DSQfrt_low=lrintercept +   (kidgrp*lrkidb) + (teengrp*lrteenb)  + (ffrtjc*lrfjcb) +  (ffruit*lrfruitb)  ;

  DSQssb_low=lxintercept +  (kidgrp*lxkidb) + (teengrp*lxteenb) +  (ssoda*lxsodab) +  (senergy*lxspdrb) + (sswtct*lxswctb)  ;

  label 
 DSQfvl_low ='Predicted probability of eating less than 1.7 cup equivalents of fruits and vegetables including legumes and French fries'
 DSQfvlnf_low ='Predicted probability of eating less than 1.7 cup equivalents fruits and vegetables including legumes and excluding French fries'
 DSQfrt_low ='Predicted probability of eating less than 0.5 cup equivalents of fruits'
 DSQvlall_low ='Predicted probability of eating less than 1.0 cup equivalents of vegetables including legumes and French fries'
 DSQvlnf_low ='Predicted probability of eating less than 1.0 cup equivalents vegetables including legumes and excluding French fries'
 DSQdairy_low ='Predicted probability of eating less than 1.2 cup equivalents of dairy'
 DSQsug_low ='Predicted probability of eating less than 11 tsp equivalents of total added sugars'
 DSQssb_low ='Predicted probability of eating less than 3 tsp equivalents added sugars from sugar-sweetened beverages'
 DSQwhgr_low ='Predicted probability of eating less than 0.3 ounce equivalents of whole grains' 
 DSQfib_low ='Predicted probability of eating less than 12 grams of fiber'
 DSQcalc_low ='Predicted probability of eating less than 800 milligrams of calcium';
  
  array lpred DSQfib_low--DSQssb_low;
  do over lpred;
    if lpred ne . then do;

  if lpred < -100 then 
    lpred = exp(-100)/(1+exp(-100));
   else if lpred > 100 then 
    lpred = exp(100)/(1+exp(100));
   else  lpred = exp(lpred)/(1+exp(lpred));
   end;
  end;


  DSQfib_high=ufintercept +  (kidgrp*ufkidb) + (teengrp*ufteenb)  + (gfb1f*ufcer1b) + (gfb2f*ufcer2b) + (gfb3f*ufcer3b) + (gwhgbrd*ufwgbb) + (gbrrice*ufbrricb) + 
     (gcheese*ufcheesb) +  (gpizza*ufpizzab) +  (gmilk*ufmilkb) +  (gicecrm*uficecrb) +  (gpopcorn*ufpcornb) + 
     (gsoda*ufsodab) +  (genergy*ufspdrb) +  (gcake*ufcakeb) +  (gdonut*ufdonutb) +  (gswtct*ufswctb) +  (gcandy*ufcandyb) + 
     (gfrtjc*uffjcb) +  (gfruit*uffruitb)  +  (gsalad*ufsaladb) + (gothpot*ufothptb) +  (gbean*ufbeanb) +
     (gothveg*ufothvgb) +  (gfrfry*uffrfrb) +  (gtomsc*uftomscb) +  (gsalsa*ufsalsab) ;

  DSQcalc_high=ucintercept +  (kidgrp*uckidb) + (teengrp*ucteenb)  + (gcm1f*uccer1b) + (gcm2f*uccer2b) + (gcm3f*uccer3b) + (gwhgbrd*ucwgbb) + (gbrrice*ucbrricb) + 
     (gcheese*uccheesb) +  (gpizza*ucpizzab) +  (gmilk*ucmilkb) +  (gicecrm*ucicecrb) +  (gpopcorn*ucpcornb) + 
     (gsoda*ucsodab) +  (genergy*ucspdrb) +  (gcake*uccakeb) +  (gdonut*ucdonutb) +  (gswtct*ucswctb) +  (gcandy*uccandyb) + 
     (gfrtjc*ucfjcb) +  (gfruit*ucfruitb)  +  (gsalad*ucsaladb) + (gothpot*ucothptb) +  (gbean*ucbeanb) +
     (gothveg*ucothvgb) +  (gfrfry*ucfrfrb) +  (gtomsc*uctomscb) +  (gsalsa*ucsalsab) ;

  DSQwhgr_high=ugintercept +  (kidgrp*ugkidb) + (teengrp*ugteenb)  + (gwg1f*ugcer1b) + (gwg2f*ugcer2b) + (gwg3f*ugcer3b) + (gwhgbrd*ugwgbb) + (gbrrice*ugbrricb) + 
      (gpopcorn*ugpcornb)  ;

  DSQsug_high=usintercept +  (kidgrp*uskidb) + (teengrp*usteenb)  + (sas1f*uscer1b) + (sas2f*uscer2b) + (sas3f*uscer3b) +  
     (sicecrm*usicecrb) +  (ssoda*ussodab) +  (senergy*usspdrb) +  (scake*uscakeb) +  (sdonut*usdonutb) +  (sswtct*usswctb) +  (scandy*uscandyb) ;

  DSQdairy_high=udintercept +   (kidgrp*udkidb) + (teengrp*udteenb)  + (dcheese*udcheesb) +  (dpizza*udpizzab) +  (dmilk*udmilkb) +  (dicecrm*udicecrb)  ;

  DSQfvl_high=upintercept +   (kidgrp*upkidb) + (teengrp*upteenb) +  
     (pfrtjc*upfjcb) +  (pfruit*upfruitb)  +  (psalad*upsaladb) + (pothpot*upothptb) +  (pbean*upbeanb) +
     (pothveg*upothvgb) +  (pfrfry*upfrfrb) +  (ptomsc*uptomscb) +  (psalsa*upsalsab) +  (ppizza*uppizzab) ;

  DSQvlall_high=uvintercept +   (kidgrp*uvkidb) + (teengrp*uvteenb) +  
     (vsalad*uvsaladb) + (vothpot*uvothptb) +  (vbean*uvbeanb) +  (vpizza*uvpizzab) +
     (vothveg*uvothvgb) +  (vfrfry*uvfrfrb) +  (vtomsc*uvtomscb) +  (vsalsa*uvsalsab) ;

  DSQfvlnf_high=unintercept +   (kidgrp*unkidb) + (teengrp*unteenb) +  
     (pfrtjc*unfjcb) +  (pfruit*unfruitb)  +  (psalad*unsaladb) + (pothpot*unothptb) +  (pbean*unbeanb) +
     (pothveg*unothvgb) +  (ptomsc*untomscb) +  (psalsa*unsalsab) + (ppizza*unpizzab) ;

  DSQvlnf_high=uuintercept +   (kidgrp*uukidb) + (teengrp*uuteenb) +  
     (vsalad*uusaladb) + (vothpot*uuothptb) +  (vbean*uubeanb) +  (vpizza*uupizzab) +
     (vothveg*uuothvgb) +  (vtomsc*uutomscb) +  (vsalsa*uusalsab) ;

  DSQfrt_high=urintercept +   (kidgrp*urkidb) + (teengrp*urteenb)  + (ffrtjc*urfjcb) +  (ffruit*urfruitb)  ;

  DSQssb_high=uxintercept +  (kidgrp*uxkidb) + (teengrp*uxteenb) +  (ssoda*uxsodab) +  (senergy*uxspdrb) + (sswtct*uxswctb)  ;

  label 
 DSQfvl_high ='Predicted probability of eating equal or more than 3.2 cup equivalents of fruits and vegetables including legumes and French fries'
 DSQfvlnf_high ='Predicted probability of eating equal or more than 3.2 cup equivalents fruits and vegetables including legumes and excluding French fries'
 DSQfrt_high ='Predicted probability of eating equal or more than 1.4 cup equivalents of fruits'
 DSQvlall_high ='Predicted probability of eating equal or more than 1.8 cup equivalents of vegetables including legumes and French fries'
 DSQvlnf_high ='Predicted probability of eating equal or more than 1.8 cup equivalents vegetables including legumes and excluding French fries'
 DSQdairy_high ='Predicted probability of eating equal or more than 2.4 cup equivalents of dairy'
 DSQsug_high ='Predicted probability of eating equal or more than 23 tsp equivalents of total added sugars'
 DSQssb_high ='Predicted probability of eating equal or more than 11 tsp equivalents added sugars from sugar-sweetened beverages'
 DSQwhgr_high ='Predicted probability of eating equal or more than 1.0 ounce equivalents of whole grains' 
 DSQfib_high ='Predicted probability of eating equal or more than 19 grams of fiber'
 DSQcalc_high ='Predicted probability of eating equal or more than 1100 milligrams of calcium';

  array upred DSQfib_high--DSQssb_high;
  do over upred;
    if upred ne . then do;

  if upred < -100 then 
    upred = exp(-100)/(1+exp(-100));
   else if upred > 100 then 
    upred = exp(100)/(1+exp(100));
   else  upred = exp(upred)/(1+exp(upred));
   end;
  end;

run;



/*show results of scoring algorithm;
*/
proc means n nmiss min max mean;
  by gender;
  var DSQfib--DSQssb_high;
  title2 'predicated intake based on screener responses';
  format gender gender.;
run;




