/*

DSQ Self-Administered Questionnaire: Web Version 1.0 (December, 2011)

  SAS program to analyze Dietary Screener Questionnaire (DSQ) 
  data exported from the DSQ web site. This program expects the DSQ 
  data to be in DietCalc format which is the default data export 
  format.
  
  !!! NOTE:  This program should only be used for studies with DSQ system study id 
             numbers 1 through 8.  If your study id is greater than 8, this program 
             will not function with your study's data file.
  
  Please contact technical support at dhq@imsweb.com if you have 
  questions or require assistance.
  
*/


/* 
  The following file should be exported from the Dietary Screener 
  Questionnaire (DSQ) web site.  The file must be in DietCalc format 
  which is the default export format.
*/   
filename yourdata '**insert file name for dsq data in DietCalc format**';



/*
  The following files are contained within the archive that 
  contained this analysis program.  Once extracted from the archive, 
  these files should be located in the same folder/directory as 
  the analysis program.
*/  
filename ntile './cereal.attributes.by.letter.xls';
filename af './portion.size.xls'; 
filename ce './regression.coefficients.xls'; 


proc format;  
  value gender 1='male'
               2='female';
  value agecut 1='2 - 17'
               2='>= 18'
	       3='2-11'
	       4='12-17';

value $didfmt  /* Applies to all *_did variables */
'A'='Yes'
'B'='No'
'C'="Don't Know"
other="Missing"
;

value $unitsfmt /* Applies to all *_units variables */
'A'="PerDay"
'B'="perWeek"
'C'="PerMonth"
'E'="Don't know"
other="Missing"
;

value $milkchoicefmt  /* Applies to the milk_choice variable */
"A"="Whole or regular milk"
"B"="2% fat or reduced-fat milk"
"C"="1%, 1/2%, or low-fat milk"
"D"="Fat-free, skim or nonfat milk"
"E"="Soy milk"
"F"="Other"
other="Missing"
;

value $cerealchoicefmt  /* Applies to the cereal_1_choice and cereal_2_choice variables */
"A"="100% Bran"
"B"="100% Low Fat Natural Granola"
"C"="100% Natural Cereal"
"D"="100% Natural Cereal, with oats, honey and raisins"
"E"="100% Natural Granola, Oats & Honey"
"F"="100% Natural Wholegrain Cereal with raisins, lowfat"
"G"="All-Bran"
"H"="All-Bran Bran Buds"
"I"="All-Bran with Extra Fiber"
"J"="Alpen"
"K"="Alpha-Bits"
"L"="Alpha-Bits with marshmallows"
"M"="Amaranth Flakes"
"N"="Apple Jacks"
"O"="Apple Zaps"
"P"="Apple Zings, Malt-O-Meal"
"Q"="Banana Nut Crunch Cereal"
"R"="Barley"
"S"="Basic 4"
"T"="Berry Colossal Crunch, Malt-O-Meal"
"U"="Blueberry Morning"
"V"="Booberry"
"W"="Bran"
"X"="Bran Buds"
"Y"="Bran flakes"
"Z"="Bran, Nabisco"
"AA"="Branola"
"AB"="Brown Sugar Bliss"
"AC"="Buckwheat groats"
"AD"="Bulgur"
"AE"="Cap'n Crunch"
"AF"="Cap'n Crunch's Christmas Crunch"
"AG"="Cap'n Crunch's Crunch Berries"
"AH"="Cap'n Crunch's Oops! ChocoDonuts"
"AI"="Cap'n Crunch's Peanut Butter Crunch"
"AJ"="Cheerios"
"AK"="Cheerios, Apple Cinnamon"
"AL"="Cheerios, Berry Burst"
"AM"="Cheerios, Berry Burst Strawberry"
"AN"="Cheerios, Berry Burst Triple Berry"
"AO"="Cheerios, Berry Burst, Cherry Vanilla"
"AP"="Cheerios, Berry Burst, Strawberry Banana"
"AQ"="Cheerios, Frosted"
"AR"="Cheerios, Honey Nut"
"AS"="Cheerios, Multi Grain"
"AT"="Cheerios, Team"
"AU"="Cheerios, Yogurt Burst, Strawberry"
"AV"="Cheerios, Yogurt Burst, Vanilla"
"AW"="Cheese grits"
"AX"="Chex"
"AY"="Chex Morning Mix Banana Nut"
"AZ"="Chex Morning Mix Cinnamon"
"BA"="Chex Morning Mix Fruit & Nut"
"BB"="Chex Morning Mix Honey Nut"
"BC"="Chex, Bran"
"BD"="Chex, Corn"
"BE"="Chex, Honey Nut"
"BF"="Chex, Multi-Bran"
"BG"="Chex, Rice"
"BH"="Chex, Wheat"
"BI"="Chocolate frosted cereal"
"BJ"="Cinnamon Cluster Raisin Bran"
"BK"="Cinnamon Crunch Crispix"
"BL"="Cinnamon Grahams Cereal"
"BM"="Cinnamon Marshmallow Scooby Doo!"
"BN"="Cinnamon Toast Crunch"
"BO"="Cinnamon Toast Crunch, Reduced Sugar"
"BP"="Coco-Roos, Malt-O-Meal"
"BQ"="Cocoa Blasts"
"BR"="Cocoa Comets"
"BS"="Cocoa Dyno Bites, Malt-O-Meal"
"BT"="Cocoa Krispies"
"BU"="Cocoa Pebbles"
"BV"="Cocoa Puffs"
"BW"="Cocoa Puffs, Reduced Sugar"
"BX"="Cocoa Wheats"
"BY"="Complete Bran Flakes"
"BZ"="Complete Oat Bran Flakes"
"CA"="Complete Wheat Bran Flakes"
"CB"="Cookie-Crisp (all flavors)"
"CC"="Corn Bursts, Malt-O-Meal"
"CD"="Corn Flakes, Kellogg's"
"CE"="Corn Pops"
"CF"="Corn Puffs"
"CG"="Corn flakes"
"CH"="Corn flakes, low sodium"
"CI"="Cornmeal mush"
"CJ"="Count Chocula"
"CK"="Cracklin' Oat Bran"
"CL"="Cranberry Almond Crunch Cereal"
"CM"="Cream of Rice"
"CN"="Cream of Rye"
"CO"="Cream of Wheat"
"CP"="Crisp Crunch"
"CQ"="Crispix"
"CR"="Crispy Brown Rice Cereal"
"CS"="Crispy Rice"
"CT"="Crispy Rice, Malt-O-Meal"
"CU"="Crispy Wheats'N Raisins"
"CV"="Crunchy Corn Bran"
"CW"="Disney Cereal"
"CX"="Disney Hunny B's"
"CY"="Disney Mickey's Magix"
"CZ"="Disney Mud & Bugs"
"DA"="Ener-G Pure Rice Bran"
"DB"="Familia"
"DC"="Farina"
"DD"="Fiber 7 Flakes"
"DE"="Fiber One"
"DF"="Frankenberry"
"DG"="French Toast Crunch"
"DH"="Froot Loops"
"DI"="Frosted Flakes, Kellogg's"
"DJ"="Frosted Flakes, Malt-O-Meal"
"DK"="Frosted Fruit Rings"
"DL"="Frosted Mini Spooners, Malt-O-Meal"
"DM"="Frosted Mini Wheats"
"DN"="Frosted Shredded Wheat"
"DO"="Frosted Wheat Bites"
"DP"="Frosted cereal, with marshmallows"
"DQ"="Frosted corn flakes"
"DR"="Frosted flakes"
"DS"="Frosted rice"
"DT"="Frosty O's"
"DU"="Fruit & Fibre (fiber)"
"DV"="Fruit & Fibre (fiber) with Dates, Raisins and Walnuts"
"DW"="Fruit & Fibre (fiber) with Peaches, Raisins, Almonds, and Oat Clusters"
"DX"="Fruit Harvest"
"DY"="Fruit Harvest Apple Cinnamon"
"DZ"="Fruit Harvest Strawberry Blueberry"
"EA"="Fruit Loops"
"EB"="Fruit Rings"
"EC"="Fruit Whirls"
"ED"="Fruit and Cream Oatmeal"
"EE"="Fruity Dyno Bites, Malt-O-Meal"
"EF"="Fruity Pebbles"
"EG"="Golden Crisp"
"EH"="Golden Grahams"
"EI"="Golden Puffs, Malt-O-Meal"
"EJ"="Granola"
"EK"="Granola, homemade"
"EL"="Granola, lowfat"
"EM"="Granola, lowfat, Kellogg's"
"EN"="Granola, lowfat, with Raisins, Kellogg's"
"EO"="Grape Nut O's"
"EP"="Grape-Nuts"
"EQ"="Grape-Nuts Flakes"
"ER"="Great Grains Crunchy Pecan Whole Grain Cereal"
"ES"="Great Grains, Raisins, Dates, and Pecans Whole Grain Cereal"
"ET"="Grits"
"EU"="Harina de maize con leche"
"EV"="Harmony Vanilla Almond Oats"
"EW"="Healthy Choice"
"EX"="Honey Bunches of Oat Honey Roasted"
"EY"="Honey Bunches of Oat with Strawberry"
"EZ"="Honey Bunches of Oats"
"FA"="Honey Bunches of Oats with Almonds"
"FB"="Honey Buzzers, Malt-O-Meal"
"FC"="Honey Crisp Corn Flakes"
"FD"="Honey Crunch Corn Flakes"
"FE"="Honey Graham Squares, Malt-O-Meal"
"FF"="Honey Nut Clusters"
"FG"="Honey Nut Heaven"
"FH"="Honey Nut Shredded Wheat"
"FI"="Honey Smacks"
"FJ"="Honeycomb"
"FK"="Honeycomb, strawberry"
"FL"="Instant Grits, all flavors"
"FM"="Jenny O's"
"FN"="Just Right"
"FO"="Just Right with Fruit & Nut"
"FP"="Kaboom"
"FQ"="Kasha"
"FR"="Kashi"
"FS"="Kashi GOLEAN"
"FT"="Kashi Good Friends"
"FU"="Kashi Good Friends Cinna-Raisin Crunch"
"FV"="Kashi Heart to Heart Cereal"
"FW"="Kashi Honey Puffed"
"FX"="Kashi Medley"
"FY"="Kashi Organic Promise"
"FZ"="Kashi Pilaf"
"GA"="Kashi Pillows"
"GB"="Kashi Seven in the Morning"
"GC"="Kashi, Puffed"
"GD"="Kix"
"GE"="Kix, Berry Berry"
"GF"="Life (plain and cinnamon)"
"GG"="Lucky Charms"
"GH"="Lucky Charms, Berry"
"GI"="Lucky Charms, Chocolate"
"GJ"="Magic Stars"
"GK"="Malt-O-Meal"
"GL"="Malt-O-Meal, chocolate"
"GM"="Maltex"
"GN"="Marshmallow Mateys, Malt-O-Meal"
"GO"="Marshmallow Safari"
"GP"="Masa harina"
"GQ"="Maypo"
"GR"="Millet"
"GS"="Millet, puffed"
"GT"="Mini-Wheats"
"GU"="Mini-Wheats Frosted Bite Size"
"GV"="Mini-Wheats Frosted Original"
"GW"="Mini-Wheats Frosted Raisin"
"GX"="Mini-Wheats Frosted Strawberry"
"GY"="Mother's Natural Foods Cereal, Quaker"
"GZ"="Muesli"
"HA"="Muesli(x)"
"HB"="Multigrain Oatmeal"
"HC"="Multigrain cereal"
"HD"="Natural Bran Flakes"
"HE"="Nature Valley Granola"
"HF"="Nature Valley Granola, with fruit and nuts"
"HG"="Nesquik"
"HH"="Nestum"
"HI"="Nu System Cuisine Toasted Grain Circles"
"HJ"="Nutri-Grain"
"HK"="Nutri-Grain Golden Wheat and Raisin"
"HL"="Nutty Nuggets"
"HM"="OS"
"HN"="Oat Bran Cereal, Quaker"
"HO"="Oat Bran Flakes, Health Valley"
"HP"="Oat bran cereal"
"HQ"="Oat bran uncooked"
"HR"="Oat cereal"
"HS"="Oat flakes"
"HT"="Oatmeal"
"HU"="Oatmeal Crisp"
"HV"="Oatmeal Crisp with Almonds"
"HW"="Oatmeal Crisp, Apple Cinnamon"
"HX"="Oatmeal Crisp, Raisin"
"HY"="Oatmeal Squares"
"HZ"="Oatmeal Swirlers"
"IA"="Oats, raw"
"IB"="Oh's"
"IC"="Oh's, Apple Cinnamon"
"ID"="Oh's, Fruitangy"
"IE"="Oh's, Honey Graham"
"IF"="Old Wessex Irish Style Oatmeal"
"IG"="Optimum Slim, Nature's Path"
"IH"="Optimum, Nature's Path"
"II"="Oreo O's Cereal"
"IJ"="Peanut Butter Toast Crunch"
"IK"="Polenta"
"IL"="Product 19"
"IM"="Puffed Rice, Malt-O-Meal"
"IN"="Puffed Wheat, Malt-O-Meal"
"IO"="Quaker Dinosaur Eggs oatmeal"
"IP"="Quaker Fruit and Cream Oatmeal"
"IQ"="Quaker Instant Grits, all flavors"
"IR"="Quaker Multigrain Oatmeal"
"IS"="Quaker Oatmeal Express"
"IT"="Quaker Oatmeal Nutrition for Women"
"IU"="Quaker Oatmeal Squares"
"IV"="Quisp"
"IW"="Raisin Bran Crunch"
"IX"="Raisin Bran, Kellogg's"
"IY"="Raisin Bran, Post"
"IZ"="Raisin Nut Bran"
"JA"="Raisin bran"
"JB"="Reese's Peanut Butter Puffs"
"JC"="Rice Krispies"
"JD"="Rice Krispies, Frosted"
"JE"="Rice Krispies, Treats Cereal"
"JF"="Rice bran, uncooked"
"JG"="Rice cereal"
"JH"="Rice flakes"
"JI"="Rice polishings"
"JJ"="Rice, puffed"
"JK"="Roman Meal"
"JL"="Seven-grain Cereal"
"JM"="Seven-grain cereal"
"JN"="Shredded Wheat"
"JO"="Shredded Wheat 'N Bran"
"JP"="Shredded Wheat Spoon Size"
"JQ"="Shredded Wheat, 100%"
"JR"="Shredded Wheat, Original"
"JS"="Smacks"
"JT"="Smart Start"
"JU"="Smorz"
"JV"="Special K"
"JW"="Special K Fruit & Yogurt"
"JX"="Special K Low Carb Lifestyle Protein Plus"
"JY"="Special K Red Berries"
"JZ"="Special K Vanilla Almond"
"KA"="Strawberry Squares"
"KB"="Sun Country 100% Natural Granola, with Almonds"
"KC"="Sweet Crunch"
"KD"="Sweet Puffs"
"KE"="Tasteeos"
"KF"="Toasted Cinnamon Twists, Malt-O-Meal"
"KG"="Toasted Oatmeal Cereal"
"KH"="Toasted Oatmeal, Honey Nut"
"KI"="Toasted oat cereal"
"KJ"="Toasties"
"KK"="Toasty O's, Apple Cinnamon, Malt-O-Meal"
"KL"="Toasty O's, Honey and Nut, Malt-O-Meal"
"KM"="Toasty O's, Malt-O-Meal"
"KN"="Tony's Cinnamon Crunchers"
"KO"="Tootie Fruities, Malt-O-Meal"
"KP"="Total"
"KQ"="Total Brown Sugar & Oats"
"KR"="Total Corn Flakes"
"KS"="Total Instant Oatmeal"
"KT"="Total Raisin Bran"
"KU"="Trix"
"KV"="Trix, Reduced Sugar"
"KW"="Uncle Sam's Hi Fiber Cereal"
"KX"="Under Cover Bears"
"KY"="Waffle Crisp"
"KZ"="Weetabix Whole Wheat Cereal"
"LA"="Wheat Hearts"
"LB"="Wheat bran, unprocessed (miller's bran)"
"LC"="Wheat cereal"
"LD"="Wheat germ"
"LE"="Wheat germ, with sugar and honey"
"LF"="Wheat, puffed"
"LG"="Wheat, puffed, presweetened with sugar"
"LH"="Wheatena"
"LI"="Wheaties"
"LJ"="Wheaties Energy Crunch"
"LK"="Wheaties Raisin Bran"
"LL"="Whole wheat cereal"
"LM"="Whole wheat, cracked"
"LN"="Zoom"
"LO"="Other"
other="Missing"
;

run;


data dsq;
infile tstdat missover lrecl=300;
length cereal_1_choice $ 3;
length cereal_2_choice $ 3;

input 
@1      study_id 12.

@13     respondent_id $30.

@43     status_date YYMMDD8.

@51     Q1AGE 3.

@54     Q2SEX $1.
@55     cereal_did            $1. /* Cereal Frequency               Did you eat any hot or cold cereals? */
@56     cereal_1_freq         $4. /* Cereal Frequency               How often did you eat hot or cold cereals?  */
@60     cereal_1_units        $1. /* Freq Units                     A=PerDay, B=PerWeek, C=PerMonth, E=Don't Know */
@61     cereal_1_choice       $3.       /* Cereal Choice 1          What kind of cereal did you usually eat?&nbsp;&nbsp;Pick one. */
@64     cereal_1_other        $char25.  /* Cereal Choice 1          You selected Other for cereal. What other cereal was this?  */

@89     cereal_2_did          $1.       /* Cereal Choice 1          Was there another cereal that you usually ate?   */
@90     cereal_2_choice       $3.       /* Cereal Choice 2          What second kind of cereal did you usually eat?&nbsp;&nbsp;Pick one.   */
@93     cereal_2_other        $char25.  /* Cereal Choice 2          You selected Other for cereal. What other cereal was this?  */

@118    milk_did              $1.       /* Milk                     Did you have any milk (either to drink or on cereal)?  */
@119    milk_freq             $4.       /* Milk                     How often did you have any milk (either to drink or on cereal)?  */
@123    milk_units            $1.       /* Freq Units               A=PerDay, B=PerWeek, C=PerMonth, E=Don't Know */
@124    milk_choice           $1.       /* Milk                     What kind of milk did you usually drink? */
@125    milk_other            $char25.  /* Milk                     You selected Other for type of milk.  What kind of milk was this? */

@150    soda_did              $1. /* Regular Soda                   Did you drink any regular soda or pop that contains sugar?    */
@151    soda_freq             $4. /* Regular Soda                   How often did you drink regular soda or pop?   */
@155    soda_units            $1. /* Freq Units                     A=PerDay, B=PerWeek, C=PerMonth, E=Don't Know */

@156    juice_did             $1. /* 100% Pure Fruit Juices         Did you drink any 100% pure fruit juices such as orange, mango, apple, grape and pineapple juices?   */
@157    juice_freq            $4. /* 100% Pure Fruit Juices         How often did you drink 100% pure fruit juice? */
@161    juice_units           $1. /* Freq Units                     A=PerDay, B=PerWeek, C=PerMonth, E=Don't Know */

@162    coffee_did            $1. /* Sweetened Coffee and Tea       Did you drink any coffee or tea that had sugar or honey added to it?  */
@163    coffee_freq           $4. /* Sweetened Coffee and Tea       How often did you drink coffee or tea containing sugar or honey?   */
@167    coffee_units          $1. /* Freq Units                     A=PerDay, B=PerWeek, C=PerMonth, E=Don't Know */

@168    sweet_drinks_did      $1. /* Other Sweetened Drinks         Did you drink any sweetened fruit drinks, sports or energy drinks, such as Kool-aid, lemonade, Hi-C, cranberry drink, Gatorade, Red Bull, or Vitamin Water?   */
@169    sweet_drinks_freq     $4. /* Other Sweetened Drinks         How often did you drink sweetened fruit, sports or energy drinks?   */
@173    sweet_drinks_units    $1. /* Freq Units                     A=PerDay, B=PerWeek, C=PerMonth, E=Don't Know */

@174    fruit_did             $1. /* Fruit                          Did you eat any fruit? Include fresh, frozen, or canned fruit. Do not include juices.  */
@175    fruit_freq            $4. /* Fruit                          How often did you eat fruit? */
@179    fruit_units           $1. /* Freq Units                     A=PerDay, B=PerWeek, C=PerMonth, E=Don't Know */

@180    salad_did             $1. /* Green Salad                    Did you eat a green leafy or lettuce salad, with or without other vegetables?  */
@181    salad_freq            $4. /* Green Salad                    How often did you eat salad? */
@185    salad_units           $1. /* Freq Units                     A=PerDay, B=PerWeek, C=PerMonth, E=Don't Know */

@186    potatoes_fried_did    $1. /* Fried Potatoes                 Did you eat any kind of fried potatoes including french fries, home fries, or hash brown potatoes?  */
@187    potatoes_fried_freq   $4. /* Fried Potatoes                 How often did you eat any kind of fried potatoes? */
@191    potatoes_fried_units  $1. /* Freq Units                     A=PerDay, B=PerWeek, C=PerMonth, E=Don't Know */

@192    potatoes_oth_did      $1. /* Other Potatoes                 Did you eat any other kind of potatoes, such as baked, boiled, mashed potatoes, sweet potatoes, or potato salad?   */
@193    potatoes_oth_freq     $4. /* Other Potatoes                 How often did you eat any other kind of potatoes? */
@197    potatoes_oth_units    $1. /* Freq Units                     A=PerDay, B=PerWeek, C=PerMonth, E=Don't Know */

@198    dry_beans_did         $1. /* Cooked Dried Beans             Did you eat any refried beans, baked beans, beans in soup, pork and beans or other cooked dried beans?  */
@199    dry_beans_freq        $4. /* Cooked Dried Beans             How often did you eat refried beans, baked beans, beans in soup, pork and beans or other cooked dried beans?  */
@203    dry_beans_units       $1. /* Freq Units                     A=PerDay, B=PerWeek, C=PerMonth, E=Don't Know */

@204    grains_did            $1. /* Whole Grains                   Did you eat any brown rice or other cooked whole grains, such as bulgur, cracked wheat, or millet? Do not include white rice. */
@205    grains_freq           $4. /* Whole Grains                   How often did you eat brown rice or other cooked whole grains?*/
@209    grains_units          $1. /* Freq Units                     A=PerDay, B=PerWeek, C=PerMonth, E=Don't Know */

@210    vegetables_did        $1. /* Other Vegetables               not including green salads, potatoes, and cooked dried beans, did you eat any other vegetables?  */
@211    vegetables_freq       $4. /* Other Vegetables               How often did you eat other vegetables?  */
@215    vegetables_units      $1. /* Freq Units                     A=PerDay, B=PerWeek, C=PerMonth, E=Don't Know */

@216    salsa_did             $1. /* Salsa                          Did you eat any Mexican-type salsa made with tomato?   */
@217    salsa_freq            $4. /* Salsa                          How often did you have Mexican-type salsa made with tomato?   */
@221    salsa_units           $1. /* Freq Units                     A=PerDay, B=PerWeek, C=PerMonth, E=Don't Know */

@222    pizza_did             $1. /* Pizza                          Did you eat any pizza? Include frozen pizza, fast food pizza, and homemade pizza. */
@223    pizza_freq            $4. /* Pizza                          How often did you eat pizza? */
@227    pizza_units           $1. /* Freq Units                     A=PerDay, B=PerWeek, C=PerMonth, E=Don't Know */

@228    sauce_did             $1. /* Tomato Sauce                   Did you have any tomato sauces such as with spaghetti or noodles or mixed into foods such as lasagna?   */
@229    sauce_freq            $4. /* Tomato Sauce                   How often did you have tomato sauces? */
@233    sauce_units           $1. /* Freq Units                     A=PerDay, B=PerWeek, C=PerMonth, E=Don't Know */

@234    cheese_did            $1. /* Cheese                         Did you eat any kind of cheese?   */
@235    cheese_freq           $4. /* Cheese                         How often did you eat any kind of cheese?   */
@239    cheese_units          $1. /* Freq Units                     A=PerDay, B=PerWeek, C=PerMonth, E=Don't Know */

@240    red_meat_did          $1. /* Red Meat                       Did you eat any red meat, such as beef, pork, ham, or sausage? */
@241    red_meat_freq         $4. /* Red Meat                       How often did you eat red meat? */
@245    red_meat_units        $1. /* Freq Units                     A=PerDay, B=PerWeek, C=PerMonth, E=Don't Know */

@246    proc_meat_did         $1. /* Processed Meat                 Did you eat any processed meat, such as bacon, lunch meats, or hot dogs? */
@247    proc_meat_freq        $4. /* Processed Meat                 How often did you eat processed meat? */
@251    proc_meat_units       $1. /* Freq Units                     A=PerDay, B=PerWeek, C=PerMonth, E=Don't Know */

@252    bread_did             $1. /* Whole Grain Bread              Did you eat any whole grain bread including toast, rolls and in sandwhiches?  */
@253    bread_freq            $4. /* Whole Grain Bread              How often did you eat whole grain bread? */
@257    bread_units           $1. /* Freq Units                     A=PerDay, B=PerWeek, C=PerMonth, E=Don't Know */

@258    candy_did             $1. /* Chocolate and Candy            Did you eat any chocolate or any other types of candy? Do not include sugar-free candy. */
@259    candy_freq            $4. /* Chocolate and Candy            How often did you eat chocolate or any other types of candy? */
@263    candy_units           $1. /* Freq Units                     A=PerDay, B=PerWeek, C=PerMonth, E=Don't Know */

@264    doughnuts_did         $1. /* Doughnuts                      Did you eat any doughnuts, sweet rolls, Danish, muffins, (pan dulce) or pop-tarts? Do not include sugar-free items.  */
@265    doughnuts_freq        $4. /* Doughnuts                      How often did you eat doughnuts, sweet rolls, Danish, muffins, (pan dulce) or pop-tarts? */
@269    doughnuts_units       $1. /* Freq Units                     A=PerDay, B=PerWeek, C=PerMonth, E=Don't Know */

@270    cookies_did           $1. /* Cookies, Cakes, Pie, Brownies  Did you eat any cookies, cake, pie, or brownies? Do not include sugar-free kinds.   */
@271    cookies_freq          $4. /* Cookies, Cakes, Pie, Brownies  How often did you eat cookies, cake, pie, or brownies?  */
@275    cookies_units         $1. /* Freq Units                     A=PerDay, B=PerWeek, C=PerMonth, E=Don't Know */

@276    desserts_did          $1. /* Frozen Desserts                Did you eat any ice cream or other frozen desserts? Do not include sugar-free kinds.   */
@277    desserts_freq         $4. /* Frozen Desserts                How often did you eat ice cream or other frozen desserts?  */
@281    desserts_units        $1. /* Freq Units                     A=PerDay, B=PerWeek, C=PerMonth, E=Don't Know */

@282    popcorn_did           $1. /* Popcorn                        Did you eat any popcorn? */
@283    popcorn_freq          $4. /* Popcorn                        How often did you eat popcorn?  */
@287    popcorn_units         $1. /* Freq Units                     A=PerDay, B=PerWeek, C=PerMonth, E=Don't Know */
;
run;


data dsq;
  set dsq;


  *converting responses into times per day for food variables of interest;


  %macro xpd (did,unit,often,outv,maxv);
  if &did='B' then &outv=0;
    else if &did='A' then do;
     if &unit='A' then &outv=1*&often;
       else if &unit='B' then &outv=1*&often/7;
       else if &unit='C' then &outv=1*&often/30;
     end;
    *remove outliers;
    if &outv > &maxv then &outv=.;
  %mend;

  %xpd(cereal_did,cereal_1_units,cereal_1_freq,hccerxpd,7);
  %xpd(milk_did,milk_units,milk_freq,milkxpd,10);
  %xpd(soda_did,soda_units,soda_freq,sodaxpd,8);
  %xpd(juice_did,juice_units,juice_freq,frtjcxpd,8);
  %xpd(coffee_did,coffee_units,coffee_freq,swtctxpd,10);
  %xpd(sweet_drinks_did,sweet_drinks_units,sweet_drinks_freq,energyxpd,7);
  %xpd(fruit_did,fruit_units,fruit_freq,fruitxpd,8);
  %xpd(salad_did,salad_units,salad_freq,saladxpd,5);
  %xpd(potatoes_fried_did,potatoes_fried_units,potatoes_fried_freq,frfryxpd,5);
  %xpd(potatoes_oth_did,potatoes_oth_units,potatoes_oth_freq,othpotxpd,3);
  %xpd(dry_beans_did,dry_beans_units,dry_beans_freq,beanxpd,4);
  %xpd(vegetables_did,vegetables_units,vegetables_freq,othvegxpd,5);
  %xpd(pizza_did,pizza_units,pizza_freq,pizzaxpd,2);
  %xpd(salsa_did,salsa_units,salsa_freq,salsaxpd,3);
  %xpd(sauce_did,sauce_units,sauce_freq,tomscxpd,2);
  %xpd(red_meat_did,red_meat_units,red_meat_freq,redmtxpd,6);
  %xpd(proc_meat_did,proc_meat_units,proc_meat_freq,procmtxpd,4);
  %xpd(cheese_did,cheese_units,cheese_freq,cheesexpd,6);
  %xpd(bread_did,bread_units,bread_freq,whgbrdxpd,6);
  %xpd(grains_did,grains_units,grains_freq,brricexpd,4);
  %xpd(candy_did,candy_units,candy_freq,candyxpd,8);
  %xpd(doughnuts_did,doughnuts_units,doughnuts_freq,donutxpd,5);
  %xpd(cookies_did,cookies_units,cookies_freq,cakexpd,7);
  %xpd(desserts_did,desserts_units,desserts_freq,icecrmxpd,5);
  %xpd(popcorn_did,popcorn_units,popcorn_freq,popcornxpd,3);

  label hccerxpd='number of times per day eat hot or cold cereal'
        milkxpd='number of times per day drink milk'
	sodaxpd='number of times per day drink soda'
	frtjcxpd='number of times per day drink fruit juice'
	swtctxpd='number of times per day drink sweet coffee/tea'
	energyxpd='number of times per day drink fruit/sports/energy drink'
	fruitxpd='number of times per day eat fruit'
	saladxpd='number of times per day eat salad'
	frfryxpd='number of times per day eat fried potatoes'
	othpotxpd='number of times per day eat other potatoes'
	beanxpd='number of times per day eat beans'
	othvegxpd='number of times per day eat other vegetables'
	pizzaxpd='number of times per day eat pizza'
	salsaxpd='number of times per day eat salsa'
	tomscxpd='number of times per day eat tomtato sauce'
	redmtxpd='number of times per day eat red meat'
	procmtxpd='number of times per day eat processed meat'
	cheesexpd='number of times per day eat cheese'
	whgbrdxpd='number of times per day eat whole grain bread'
	brricexpd='number of times per day eat cooked whole grain (brown rice)'
	candyxpd='number of times per day eat candy'
	donutxpd='number of times per day eat pastries'
	cakexpd='number of times per day eat cookies/cake'
	icecrmxpd='number of times per day eat ice cream'
	popcornxpd='number of times per day eat pop corn';

run;

 
data dtq;
  set dsq;

  *rename variables;
  ageinyr=q1age;
  if q2sex='A' then gender=1;
    else if q2sex='B' then gender=2;

  IF (2 <= ageinyr <= 3) THEN AGEGRP=1;                                           
    ELSE IF (4 <= ageinyr <= 5) THEN AGEGRP=2;
    ELSE IF (6 <= ageinyr <= 7) THEN AGEGRP=3;                                    
    ELSE IF (8 <= ageinyr <= 9) THEN AGEGRP=4;                                    
    ELSE IF (10 <= ageinyr <= 11) THEN AGEGRP=5;                                    
    ELSE IF (12 <= ageinyr <= 13) THEN AGEGRP=6;                                    
    ELSE IF (14 <= ageinyr <= 15) THEN AGEGRP=7;                                    
    ELSE IF (16 <= ageinyr <= 17) THEN AGEGRP=8; 
    ELSE IF (18 <= ageinyr <= 27) THEN AGEGRP=9;                                        
    ELSE IF (28 <= ageinyr <= 37) THEN AGEGRP=10;                                   
    ELSE IF (38 <= ageinyr <= 47) THEN AGEGRP=11;                                    
    ELSE IF (48 <= ageinyr <= 57) THEN AGEGRP=12;                                    
    ELSE IF (58 <= ageinyr <= 67) THEN AGEGRP=13;                                   
    ELSE IF (68 <= ageinyr <= 77) THEN AGEGRP=14;                                   
    ELSE IF ageinyr >= 78 THEN AGEGRP=15;

  /* if all ages responded to all questions, then use option a: 2-17 (agecut=1) or 18+ (agecut=2)                                */
  /* else if kids < age 12 did NOT answer sugar in coffee/tea, use option b: 2-11 (agecut=3) 12-17 (agecut=4) or 18+ (agecut=2)  */
  /*  one of the two options should remain as a comment, the other should be uncommented / this example uses b                   */

  /*option a:
  *code for 2 age groups 2-17, 18+;
  if (1 <= agegrp <= 8) then agecut=1;
    else if (9 <= agegrp <= 15) then agecut=2;
   *end of option a;*/


  /*option b: */
  *code for 3 age groups 2-11, 12-17, 18+;
  if (1 <= agegrp <= 5) then agecut=3;
    else if (6 <= agegrp <= 8) then agecut=4;
    else if (9 <= agegrp <= 15) then agecut=2;
  if agecut=3 then swtctxpd=0;
  *end of option b;
   

  cereal1fc=compress(cereal_1_choice);
  cereal2fc=compress(cereal_2_choice);

  *create numcer to represent the number of cereals provided;

  if cereal1fc='...' and cereal2fc='...' then numcer=0;
    else if cereal1fc ne '...' and cereal2fc ne '...' then numcer=2;
    else if cereal1fc ne '...' then numcer=1;

run;

proc import datafile=ntile
  out=ntile
  dbms=xls
  replace;
  getnames=yes;
run;
  

proc sort data=ntile;
  by cchoice;
run;

data ntile (keep=cereal1fc cereal2fc hotcold whgnt sugnt calcnt fibnt);
  set ntile;
  by cchoice;
  if first.cchoice;
  cereal1fc=compress(cchoice);
  cereal2fc=compress(cchoice);
run;

proc sort data=dtq;
  by cereal1fc;
run;

proc sort data=ntile;
  by cereal1fc;
run;


data dtq (drop= hotcold whgnt sugnt calcnt fibnt);
  merge dtq (in=d) ntile (drop=cereal2fc);
  by cereal1fc;
  if d;

  c1hotcold=hotcold;
  c1whgnt=whgnt;
  c1sugnt=sugnt;
  c1calcnt=calcnt;
  c1fibnt=fibnt;
run;

proc sort data=dtq;
  by cereal2fc;
run;

proc sort data=ntile;
  by cereal2fc;
run;

data dtq (drop= hotcold whgnt sugnt calcnt fibnt);
  merge dtq (in=d) ntile (drop=cereal1fc);
  by cereal2fc;
  if d;

  c2hotcold=hotcold;
  c2whgnt=whgnt;
  c2sugnt=sugnt;
  c2calcnt=calcnt;
  c2fibnt=fibnt;
run;


data dtq;
  set dtq;

  if numcer in (0,1,2) and hccerxpd >= 0 then do;
  hwg1f=0; hwg2f=0; cwg1f=0; cwg2f=0; cwg3f=0; cwg4f=0;
  has1f=0; has2f=0; cas1f=0; cas2f=0; cas3f=0; cas4f=0;
  hcm1f=0; hcm2f=0; hcm3f=0; ccm1f=0; ccm2f=0; ccm3f=0; ccm4f=0;
  hfb1f=0; hfb2f=0; hfb3f=0; cfb1f=0; cfb2f=0; cfb3f=0; cfb4f=0;
  if numcer=1 then do;
    if c1hotcold=2 and c1whgnt=1 then cwg1f=cwg1f+hccerxpd;
      else if c1hotcold=2 and c1whgnt=2 then cwg2f=cwg2f+hccerxpd;
      else if c1hotcold=2 and c1whgnt=3 then cwg3f=cwg3f+hccerxpd;
      else if c1hotcold=2 and c1whgnt=4 then cwg4f=cwg4f+hccerxpd;
      else if c1hotcold=1 and c1whgnt=1 then hwg1f=hwg1f+hccerxpd;
      else if c1hotcold=1 and c1whgnt=2 then hwg2f=hwg2f+hccerxpd;
    if c1hotcold=2 and c1sugnt=1 then cas1f=cas1f+hccerxpd;
      else if c1hotcold=2 and c1sugnt=2 then cas2f=cas2f+hccerxpd;
      else if c1hotcold=2 and c1sugnt=3 then cas3f=cas3f+hccerxpd;
      else if c1hotcold=2 and c1sugnt=4 then cas4f=cas4f+hccerxpd;
      else if c1hotcold=1 and c1sugnt=1 then has1f=has1f+hccerxpd;
      else if c1hotcold=1 and c1sugnt=2 then has2f=has2f+hccerxpd;
    if c1hotcold=2 and c1calcnt=1 then ccm1f=ccm1f+hccerxpd;
      else if c1hotcold=2 and c1calcnt=2 then ccm2f=ccm2f+hccerxpd;
      else if c1hotcold=2 and c1calcnt=3 then ccm3f=ccm3f+hccerxpd;
      else if c1hotcold=2 and c1calcnt=4 then ccm4f=ccm4f+hccerxpd;
      else if c1hotcold=1 and c1calcnt=1 then hcm1f=hcm1f+hccerxpd;
      else if c1hotcold=1 and c1calcnt=2 then hcm2f=hcm2f+hccerxpd;
      else if c1hotcold=1 and c1calcnt=3 then hcm3f=hcm3f+hccerxpd;
    if c1hotcold=2 and c1fibnt=1 then cfb1f=cfb1f+hccerxpd;
      else if c1hotcold=2 and c1fibnt=2 then cfb2f=cfb2f+hccerxpd;
      else if c1hotcold=2 and c1fibnt=3 then cfb3f=cfb3f+hccerxpd;
      else if c1hotcold=2 and c1fibnt=4 then cfb4f=cfb4f+hccerxpd;
      else if c1hotcold=1 and c1fibnt=1 then hfb1f=hfb1f+hccerxpd;
      else if c1hotcold=1 and c1fibnt=2 then hfb2f=hfb2f+hccerxpd;
      else if c1hotcold=1 and c1fibnt=3 then hfb3f=hfb3f+hccerxpd;
   end;
   else if numcer=2 then do;
    if c1hotcold=2 and c1whgnt=1 then cwg1f=cwg1f+(.75*hccerxpd);
      else if c1hotcold=2 and c1whgnt=2 then cwg2f=cwg2f+(.75*hccerxpd);
      else if c1hotcold=2 and c1whgnt=3 then cwg3f=cwg3f+(.75*hccerxpd);
      else if c1hotcold=2 and c1whgnt=4 then cwg4f=cwg4f+(.75*hccerxpd);
      else if c1hotcold=1 and c1whgnt=1 then hwg1f=hwg1f+(.75*hccerxpd);
      else if c1hotcold=1 and c1whgnt=2 then hwg2f=hwg2f+(.75*hccerxpd);
    if c2hotcold=2 and c2whgnt=1 then cwg1f=cwg1f+(.25*hccerxpd);
      else if c2hotcold=2 and c2whgnt=2 then cwg2f=cwg2f+(.25*hccerxpd);
      else if c2hotcold=2 and c2whgnt=3 then cwg3f=cwg3f+(.25*hccerxpd);
      else if c2hotcold=2 and c2whgnt=4 then cwg4f=cwg4f+(.25*hccerxpd);
      else if c2hotcold=1 and c2whgnt=1 then hwg1f=hwg1f+(.25*hccerxpd);
      else if c2hotcold=1 and c2whgnt=2 then hwg2f=hwg2f+(.25*hccerxpd);
    if c1hotcold=2 and c1sugnt=1 then cas1f=cas1f+(.75*hccerxpd);
      else if c1hotcold=2 and c1sugnt=2 then cas2f=cas2f+(.75*hccerxpd);
      else if c1hotcold=2 and c1sugnt=3 then cas3f=cas3f+(.75*hccerxpd);
      else if c1hotcold=2 and c1sugnt=4 then cas4f=cas4f+(.75*hccerxpd);
      else if c1hotcold=1 and c1sugnt=1 then has1f=has1f+(.75*hccerxpd);
      else if c1hotcold=1 and c1sugnt=2 then has2f=has2f+(.75*hccerxpd);
    if c2hotcold=2 and c2sugnt=1 then cas1f=cas1f+(.25*hccerxpd);
      else if c2hotcold=2 and c2sugnt=2 then cas2f=cas2f+(.25*hccerxpd);
      else if c2hotcold=2 and c2sugnt=3 then cas3f=cas3f+(.25*hccerxpd);
      else if c2hotcold=2 and c2sugnt=4 then cas4f=cas4f+(.25*hccerxpd);
      else if c2hotcold=1 and c2sugnt=1 then has1f=has1f+(.25*hccerxpd);
      else if c2hotcold=1 and c2sugnt=2 then has2f=has2f+(.25*hccerxpd);
    if c1hotcold=2 and c1calcnt=1 then ccm1f=ccm1f+(.75*hccerxpd);
      else if c1hotcold=2 and c1calcnt=2 then ccm2f=ccm2f+(.75*hccerxpd);
      else if c1hotcold=2 and c1calcnt=3 then ccm3f=ccm3f+(.75*hccerxpd);
      else if c1hotcold=2 and c1calcnt=4 then ccm4f=ccm4f+(.75*hccerxpd);
      else if c1hotcold=1 and c1calcnt=1 then hcm1f=hcm1f+(.75*hccerxpd);
      else if c1hotcold=1 and c1calcnt=2 then hcm2f=hcm2f+(.75*hccerxpd);
      else if c1hotcold=1 and c1calcnt=3 then hcm3f=hcm3f+(.75*hccerxpd);
    if c2hotcold=2 and c2calcnt=1 then ccm1f=ccm1f+(.25*hccerxpd);
      else if c2hotcold=2 and c2calcnt=2 then ccm2f=ccm2f+(.25*hccerxpd);
      else if c2hotcold=2 and c2calcnt=3 then ccm3f=ccm3f+(.25*hccerxpd);
      else if c2hotcold=2 and c2calcnt=4 then ccm4f=ccm4f+(.25*hccerxpd);
      else if c2hotcold=1 and c2calcnt=1 then hcm1f=hcm1f+(.25*hccerxpd);
      else if c2hotcold=1 and c2calcnt=2 then hcm2f=hcm2f+(.25*hccerxpd);
      else if c2hotcold=1 and c2calcnt=3 then hcm3f=hcm3f+(.25*hccerxpd);
    if c1hotcold=2 and c1fibnt=1 then cfb1f=cfb1f+(.75*hccerxpd);
      else if c1hotcold=2 and c1fibnt=2 then cfb2f=cfb2f+(.75*hccerxpd);
      else if c1hotcold=2 and c1fibnt=3 then cfb3f=cfb3f+(.75*hccerxpd);
      else if c1hotcold=2 and c1fibnt=4 then cfb4f=cfb4f+(.75*hccerxpd);
      else if c1hotcold=1 and c1fibnt=1 then hfb1f=hfb1f+(.75*hccerxpd);
      else if c1hotcold=1 and c1fibnt=2 then hfb2f=hfb2f+(.75*hccerxpd);
      else if c1hotcold=1 and c1fibnt=3 then hfb3f=hfb3f+(.75*hccerxpd);
    if c2hotcold=2 and c2fibnt=1 then cfb1f=cfb1f+(.25*hccerxpd);
      else if c2hotcold=2 and c2fibnt=2 then cfb2f=cfb2f+(.25*hccerxpd);
      else if c2hotcold=2 and c2fibnt=3 then cfb3f=cfb3f+(.25*hccerxpd);
      else if c2hotcold=2 and c2fibnt=4 then cfb4f=cfb4f+(.25*hccerxpd);
      else if c2hotcold=1 and c2fibnt=1 then hfb1f=hfb1f+(.25*hccerxpd);
      else if c2hotcold=1 and c2fibnt=2 then hfb2f=hfb2f+(.25*hccerxpd);
      else if c2hotcold=1 and c2fibnt=3 then hfb3f=hfb3f+(.25*hccerxpd);
    end;
   end;
run;

proc sort data=dtq;
  by gender AGEGRP;
run;

proc import datafile=af
  out=af
  dbms=xls
  replace;
  getnames=yes;
run;	 

proc sort data=af;
  by gender agegrp; 
run;

data dtq;
  merge dtq (in=d) af;
  by gender agegrp;
  if d;
run;

data dtq;
  set dtq;

  ghcerfib1=hfb1f*gP50hcereal;
  ghcerfib2=hfb2f*gP50hcereal;
  ghcerfib3=hfb3f*gP50hcereal;
  gccerfib1=cfb1f*gP50ccereal;
  gccerfib2=cfb2f*gP50ccereal;
  gccerfib3=cfb3f*gP50ccereal;
  gccerfib4=cfb4f*gP50ccereal;
  gwhgbrd=whgbrdxpd*gP50whgrd;
  gpopcorn=popcornxpd*gP50popcorn;
  gbrownrice=brricexpd*gP50brownrice;
  gcheese=cheesexpd*gP50cheese;
  gpizza=pizzaxpd*gP50pizza;
  gmilk=milkxpd*gP50milk;
  gicecream=icecrmxpd*gP50icecream;
  gregsoda=sodaxpd*gP50regsoda;
  gsportfrdrnk=energyxpd*gP50sportfrdrnk;
  gcookietc=cakexpd*gP50cookietc;
  gdonut=donutxpd*gP50donut;
  gsugincof=swtctxpd*gP50sugincof;
  gcandy=candyxpd*gP50candy;
  gfrtj=frtjcxpd*gP50frtj;
  gfruit=fruitxpd*gP50fruit;
  gsalad=saladxpd*gP50salad;
  gothpot=othpotxpd*gP50othpot;
  gdrbean=beanxpd*gP50drbean;
  gothveg=othvegxpd*gP50othveg;
  gfrfry=frfryxpd*gP50frfry;
  gtomsc=tomscxpd*gP50tomsc;
  gsalsa=salsaxpd*gP50salsa;  

  ghcercalc1=hcm1f*gP50hcereal;
  ghcercalc2=hcm2f*gP50hcereal;
  ghcercalc3=hcm3f*gP50hcereal;
  gccercalc1=ccm1f*gP50ccereal;
  gccercalc2=ccm2f*gP50ccereal;
  gccercalc3=ccm3f*gP50ccereal;
  gccercalc4=ccm4f*gP50ccereal;

  shceraddsug1=has1f*sP50hcereal;
  shceraddsug2=has2f*sP50hcereal;
  scceraddsug1=cas1f*sP50ccereal;
  scceraddsug2=cas2f*sP50ccereal;
  scceraddsug3=cas3f*sP50ccereal;
  scceraddsug4=cas4f*sP50ccereal;
  sicecream=icecrmxpd*sP50icecream;
  sregsoda=sodaxpd*sP50regsoda;
  ssportfrdrnk=energyxpd*sP50sportfrdrnk;
  scookietc=cakexpd*sP50cookietc;
  sdonut=donutxpd*sP50donut;
  ssugincof=swtctxpd*sP50sugincof;
  scandy=candyxpd*sP50candy;  

  ghcerwg1=hwg1f*gP50hcereal;
  ghcerwg2=hwg2f*gP50hcereal;
  gccerwg1=cwg1f*gP50ccereal;
  gccerwg2=cwg2f*gP50ccereal;
  gccerwg3=cwg3f*gP50ccereal;
  gccerwg4=cwg4f*gP50ccereal;

  dcheese=cheesexpd*dP50cheese;
  dpizza=pizzaxpd*dP50pizza;
  dmilk=milkxpd*dP50milk;
  dicecream=icecrmxpd*dP50icecream;

  vFRTJ=frtjcxpd*vP50FRTJ;
  vFRUIT=fruitxpd*vP50FRUIT;
  vSALAD=saladxpd*vP50SALAD;
  vOTHPOT=othpotxpd*vP50OTHPOT;
  vDRBEAN=beanxpd*vP50DRBEAN;
  vOTHVEG=othvegxpd*vP50OTHVEG;
  vFRFRY=frfryxpd*vP50FRFRY;
  vTOMSC=tomscxpd*vP50TOMSC;
  vSALSA=salsaxpd*vP50SALSA;
  vPIZZA=pizzaxpd*vP50PIZZA;

  *sum variables then transform;
  fd8sug=shceraddsug1+shceraddsug2+scceraddsug1+scceraddsug2+scceraddsug3+scceraddsug4+sicecream+
     sregsoda+ssportfrdrnk+scookietc+sdonut+ssugincof+scandy;
  fd7sug=sregsoda+ssportfrdrnk+scookietc+sdonut+sicecream+ssugincof+scandy;
  btfd8sug=(fd8sug)**.33;
  btfd7sug=(fd7sug)**.33;

  fd10FVL=vFRTJ+vFRUIT+vSALAD+vOTHPOT+vDRBEAN+vOTHVEG+vFRFRY+vTOMSC+vSALSA+vPIZZA;
  fd9FVL=vFRTJ+vFRUIT+vSALAD+vOTHPOT+vDRBEAN+vOTHVEG+vTOMSC+vSALSA+vPIZZA;
  sqrtfd10fvl=sqrt(fd10FVL);
  sqrtfd9fvl=sqrt(fd9FVL);
   
  fd3ssb=sregsoda+ssportfrdrnk+ssugincof;
  sqrtfd3ssb=sqrt(fd3ssb);

  fd4dairy=dcheese+dpizza+dmilk+dicecream;
  sqfd4dairy=sqrt(fd4dairy);


run;

proc sort data=dtq;
  by gender agecut;
run;

proc import datafile=ce
  out=ce
  dbms=xls
  replace;
  getnames=yes;
run;	 

proc sort data=ce;
  by gender agecut;
run;

data dtq;
  merge dtq (in=d) ce;
  by gender agecut;
  if d;
run;

data dtq;
  set dtq;
  by gender agecut;

  predfib=(bintercept +  (ghcerfib1*bghcerfib1) + (ghcerfib2*bghcerfib2) + (ghcerfib3*bghcerfib3) + (gccerfib1*bgccerfib1) +  
     (gccerfib2*bgccerfib2) +  (gccerfib3*bgccerfib3) +  (gccerfib4*bgccerfib4) +  (gwhgbrd*bgwhgbrd) + (gbrownrice*bgbrownrice) + 
     (gcheese*bgcheese) +  (gpizza*bgpizza) +  (gmilk*bgmilk) +  (gicecream*bgicecream) +  (gpopcorn*bgpopcorn) + 
     (gregsoda*bgregsoda) +  (gsportfrdrnk*bgsportfrdrnk) +  (gcookietc*bgcookietc) +  (gdonut*bgdonut) +  (gsugincof*bgsugincof) +  (gcandy*bgcandy) + 
     (gFRTJ*bgfrtj) +  (gFRUIT*bgfruit)  +  (gSALAD*bgsalad) + (gOTHPOT*bgothpot) +  (gDRBEAN*bgdrbean) +
     (gOTHVEG*bgothveg) +  (gFRFRY*bgfrfry) +  (gTOMSC*bgtomsc) +  (gSALSA*bgsalsa) ) ** 4;
  label predfib='daily fiber intake (g)';

  predcalc=(cintercept + (ghcercalc1*cghcercalc1) + (ghcercalc2*cghcercalc2) +  (ghcercalc3*cghcercalc3) +  (gccercalc1*cgccercalc1) +  
     (gccercalc2*cgccercalc2) +  (gccercalc3*cgccercalc3) +  (gccercalc4*cgccercalc4) +  (gwhgbrd*cgwhgbrd) + (gbrownrice*cgbrownrice) + 
     (gcheese*cgcheese) +  (gpizza*cgpizza) +  (gmilk*cgmilk) +  (gicecream*cgicecream) + (gpopcorn*cgpopcorn) +
     (gregsoda*cgregsoda) +  (gsportfrdrnk*cgsportfrdrnk) +  (gcookietc*cgcookietc) +  (gdonut*cgdonut) +  (gsugincof*cgsugincof) +  (gcandy*cgcandy) + 
     (gFRTJ*cgfrtj) +  (gFRUIT*cgfruit) +  (gSALAD*cgsalad) +  (gOTHPOT*cgothpot) +  (gDRBEAN*cgdrbean) +
     (gOTHVEG*cgothveg) +  (gFRFRY*cgfrfry) +  (gTOMSC*cgtomsc) +  (gSALSA*cgsalsa) ) ** 4;
  label predcalc='daily calcium intake (mg)';

  predsug=(wintercept + (wbeta1*btfd8sug ) )**3;
  label predsug='daily added sugar intake (tsp)';

  predwhgrn=(gintercept + (ghcerwg1*gghcerwg1) + (ghcerwg2*gghcerwg2) + (gccerwg1*ggccerwg1) + (gccerwg2*ggccerwg2)
   + (gccerwg3*ggccerwg3) + (gccerwg4*ggccerwg4) + (gwhgbrd*ggwhgbrd) + (gpopcorn*ggpopcorn) + (gbrownrice*ggbrownrice) ) **2;
  label predwhgrn = 'daily whole grain intake (ounce equivalent)';

  preddairy= (dintercept + (dbeta1*sqfd4dairy ) )**2;
  label preddairy = 'daily dairy intake (cup equivalent)';

  predfvl= (vintercept + (vbeta1*sqrtfd10fvl ) )**2;
  label predfvl = 'daily fruit/veg/legume intake (cup)';

  predfvlnf= (nintercept + (nbeta1*sqrtfd9fvl ) )**2;
  label predfvlnf = 'daily fruit/veg/legume minus french fries intake (cup)';

  predssb= (xintercept + (xbeta1*sqrtfd3ssb) ) **2;
  label predssb = 'daily intake of added sugar (tsp) from sugar sweetened beverages';
run;

*show results of scoring algorithm;
proc means n nmiss min max mean;
  by gender agecut;
  var predfib predcalc predsug predwhgrn preddairy predfvl predfvlnf predssb;
  title2 'predicated intake based on screener responses';
  format gender gender. agecut agecut.;
run;







