
\name{getDataFileInfo}
\alias{getDataFileInfo}
\title{File Information}
\description{
 Get a data frame of information for available files to download
}
\usage{ getDataFileInfo(data, type=NULL)
}
\arguments{
  \item{data}{One of "2011-12", "2013-14", or "NNYFS".}
  \item{type}{NULL or a vector containing any of 
     "Demographics", "Dietary", "Examination", "Laboratory", or "Questionnaire",
     where the strings are not case-sensitive and only the first two
     characters are matched.
     The default is NULL, so that information for all types will be returned.}
}
\details{Information contained in the returned data frame can be used in the 
     \code{\link{downloadFiles}} function.      
}

\value{
  Data frame of information for the available files.
}
%\references{}
\examples{

  x <- getDataFileInfo("2011-12")
  x[1:5, ]  

}
%\keyword{ data } 
\seealso{ \code{\link{downloadFiles}}, \code{\link{downloadAndReadFile}} }
