***  Purpose:  Create work SAS datasets for ASA24 output files.    ***
***  Study type:  Recall                                           ***
***  ASA24-2018 Studies created on or after June 1, 2018           ***;


***** change these below four values *****;

%let pgmloc = Z:\ASA24MTN\HelpDesk\SASbuildcode\ASA24-2022\Recall\;   *put location of the individual build programs, assumes all in same folder;
%let csvloc = Z:\ASA24MTN\Researcher Website\DataDictionaries\ASA242022\Recall\;  *put location of the individual csv files, assumes all in same folder;
%let study = Saffron;  *put study name here that matches the prefix of the 5 csv files;
%let itemsnum = 2022-08-18_75934;  *put the number associated with ITEMS csv file here, for example, this value relate to this file radon_2018-10-20_1365_Items.csv;

*******  there should be no need to modify code below this comment ********;

%let itemsfile = %sysfunc(cats(&csvloc,&study,_,&itemsnum,_items.,csv));
%let insfile = %sysfunc(cats(&csvloc,&study,_,&&itemsnum,_ins.,csv));
%let responsesfile = %sysfunc(cats(&csvloc,&study,_,&itemsnum,_responses.,csv));
%let totalsfile = %sysfunc(cats(&csvloc,&study,_,&itemsnum,_totals.,csv));
%let tnsfile = %sysfunc(cats(&csvloc,&study,_,&itemsnum,_tns.,csv));
%let tsfile = %sysfunc(cats(&csvloc,&study,_,&itemsnum,_ts.,csv));
%put &itemsfile; %put &insfile ; %put &responsesfile; %put &totalsfile; %put &tnsfile; %put &tsfile;


/* CREATES FORMAT CATALOG NEEDED FOR SLEEP ANSWERS AND SAVES IT IN THE SAME LOCATION AS THE CSV FILES */
proc format ;
     invalue xmiss 77777 = .R 99999 = .D ;
    value xmiss 77777 = .R 99999 = .D ;
    invalue xtime 55555 = .S 77777 = .R 99999 = .D other=[time5.] ;
    value xtime 55555 = .S 77777 = .R 99999 = .D other=[time5.] ;
run;
libname xform "&csvloc.";
proc format library = xform.FORMATS ; run ;

%include "&pgmloc.buildresponses.sas";
%include "&pgmloc.builditems.sas";
%include "&pgmloc.buildtotals.sas";
%include "&pgmloc.buildINS.sas";
%include "&pgmloc.buildTS.sas";
%include "&pgmloc.buildTNS.sas";

proc sort data=responses; by username recallno; run;
proc sort data=items; by username recallno; run;
proc sort data=totals; by username recallno; run;
proc sort data=INS; by username recallno; run;
proc sort data=TS; by username recallno; run;
proc sort data=TNS; by username recallno; run;


proc sort data=responses out=responses_one (keep=username recallno) nodupkey ; by username recallno; run;
proc sort data=items out=items_one (keep=username recallno calc) nodupkey ; by username recallno; run;
proc sort data=totals out=totals_one (keep=username recallno calc) nodupkey ; by username recallno; run;
proc sort data=ins out=INS_one (keep=username recallno calc) nodupkey ; by username recallno; run;
proc sort data=ts out=TS_one (keep=username recallno calc) nodupkey ; by username recallno; run;
proc sort data=tns out=TNS_one (keep=username recallno calc) nodupkey ; by username recallno; run;


data chkcounts;
merge responses_one (in=responsesx)
      items_one (in=itemsx drop=calc) totals_one (in=totalsx drop=calc) ins_one (in=insx drop=calc) ts_one (in=tsx drop=calc)
      tns_one (in=tnsx drop=calc);
by username recallno;
if responsesx then responses=1; else responses=0;
if itemsx then items=1; else items=0;
if totalsx then totals=1; else totals=1;
if insx then ins=1; else ins=0;
if tsx then ts=1; else ts=0;
if tnsx then tns=1; else tns=0;
run;

proc freq data=chkcounts;
tables responses*items*totals*ins*ts*tns /list; run;

