****************************************************************************;
**  Examples using the mixtran and distrib macros saved in the programs     ;
**  mixtran_macro_v2.1.sas						    ;
**  distrib_macro_v2.1.sas						    ;
****************************************************************************;

options linesize=135;

title1 "Example 1 - Model fitting and estimation of the distribution of usual intake for a dietary component consumed almost daily";
title2 "Using data from public use NHANES data, amount only model, mixtran_macro_v2.1.sas and distrib_macro_v2.1.sas";
title3 "Based on males age 9+, add_sug, weights, covariates: sequence, weekend, age group, and race";

/* the libref for the input data */
libname indata "&home\NCI_Method\Data";

/* the libref for the output data sets.                                  */
/* this libref name must be used in the macros, if data are to be saved, in the parameter outlib= */
libname mylib  "&home\NCI_Method\Examples_v2.1\example1";

/*  the user must include the programs mixtran_macro_v2.1.sas and distrib_macro_v2.1.sas */
%include "&home\NCI_Method\Macros_v2.1\mixtran_macro_v2.1.sas" ;
%include "&home\NCI_Method\Macros_v2.1\distrib_macro_v2.1.sas" ;
**************************************************************;   


proc format;
value nonzerof
         0 = '0'
    0.000001-1000 = '  > 0 ';
         value agegf
      1 ='  1-3'
      2 ='  4-8'
      3 =' 9-13'
      4 ='14-18'
      5 ='19-30'
      6 ='31-50'
      7 ='51-70'
      8 =' 71+'
   -255 = 'Overall'
      ;

** read in the data and sort by subject id;
proc sort data=indata.indiv_ims out=nhanes;
  by  seqn;
  run;

/* read in data and create dummies of analysis variables if not previosuly prepared */
data male;
	set nhanes(keep=seqn race agegrp age4-age8 rndw1 
       day day2 add_sug add_sug_rec sex sex1 stratum weekend);
  by seqn ;

  ** subset to correct age and sex; 
  if stratum = 2;  /* males aged 9+*/
 

  r_add_sug  = ( add_sug  >0 );
  
  /* creat dummies of analysis variables */
  race1=(race  = 1);
  race3=(race  = 3);

    label
      r_add_sug = "Ever/Never consumed added sugars"
      race1     = "Race: Mexican/American (ref = White)"
      race3     = "Race: Non-Hispanic Black (ref = White)"
      ;   
  run;

/* in this example, the MIXTRAN macro model type will be "amount".                  */
/* It is no longer necessary to recode consumption values of 0 to half the smallest */ 
/* amount actually consumed as this is now done in the macro MIXTRAN.               */

** preview the amountof non-consumption ** ;
proc freq data=male;
  tables r_add_sug*add_sug/missing list;
  format add_sug nonzerof.;
  title4 'Check zero consumption prior to recoding zero to half the minimum consumption within the MIXTRAN macro';
  run;

** preliminary freqs - always best to know the data **;
** Note: the NLMixed procedure will delete records with missing covariates ** ;
proc freq data=male;
    tables race*race1*race3  day*day2 agegrp weekend /missing list;
    format agegrp agegf.;
    title4 'Preliminary frequencies of nhanes data';
  run;

** data set to be used in the macro analysis is male **;

/* EXAMPLE 1 */

 /* male data, amount model, with weekend. Subgroup in DISTRIB macro  */
title4 "Output from the MIXTRAN macro"; 

%mixtran  (data=male,
	        response=add_sug,
          modeltype=amount,	        
          subject=seqn,
          repeat=day,
          outlib=mylib, 
          covars_amt=age4 age5 age6 age7 age8 race1 race3,                   
          covars_prob=, 																 /* probability covariates are not used in an amount model */
	        foodtype=add_sug_male1, 
          seq=day2,	                 
          lambda=,																			 /* allow the macro to calculate lambda     */
          replicate_var=rndw1,
          weekend=weekend,
          vargroup=,numvargroups=,  									   /* no separate residual variance requested */
          vcontrol=,start_val1=,start_val2=,start_val3=, /* this is a base run, no starting values  */
          nloptions=qmax=61,
          titles=4,
          printlevel=2);                
run;
**** note: The parameters with null values can be omitted from this call.  ***
****       They are included in the example purely for documentation.      ***;

    
/* execute the DISTRIB macro using the parameter and predicted data sets prepared by the MIXTRAN macro*/
/*  additional data from the analysis file will also be used for the subgroup and recommended amounts  */

title4 "Output from the DISTRIB macro calculating usual intake of added sugar for males";
 
run;
    
   	%Distrib  (call_type=Full, 
   	          modeltype=amount,
   	          outlib=mylib,
    	      	subject=seqn,
    	      	mcsimda=mylib._mcsim_add_sug_male_rndw1,     	      	
            	pred=mylib._pred_unc_add_sug_male1, 
            	param=mylib._param_unc_add_sug_male1,
   	          seed=5454768,            	    	      	      	      		          
   	          nsim_mc=100,
   	          food=add_sug_male,															  
    	      	byvar=,   	                               /* MIXTRAN was not fit separately for by groups */                   	                            
  	      	  cutpoints= 10 12 14 17 22 25 33 38 42 47,
  	      	  ncutpnt=10,
  	      	  wkend_prop=3/7,
    	      	add_da=male,  	      	   
    	      	subgroup=agegrp,
  		        recamt=add_sug_rec,
  		        recamt_co=lt,
  		        recamt_hi=, 															/* comparison is not a range */
    	      	titles=4);

**** note: The parameters byvar and recamt_hi can be omitted in this call since they will not be used.  ***
****       They are in the example only for the sake of documentation.                                  ***;

run;
