***************************************************************************************;
**  Example3 using the mixtran and distrib macros saved in the programs              
 ;
**  mixtran_macro_v1.1.sas and distrib_macro_v1.1.sas			               ;
**  Combining parameter and predicted data sets from sub-populations to use in DISTRIB.;
**  Re-useing data from paramater and predicted data sets in new calls to DISTRIB.     ;
***************************************************************************************;

options linesize=135;

title1 "Example 3 - Time-saving programming techniques and macro features for a more complicated situation";
title2 "Using preliminary dataset from public use NHANES data, amount-only model, mixtran_macro_v1.1.sas and distrib_macro_v1.1.sas";
title3 "Based on all subjects, add_sug, weights, covariates: sequence, weekend, age group, race, and sex";

/* the libref for the input data */
libname indata "/prj/arb/nhefs/data/userguide/v8";

/* the libref for the output data sets. this libref          */
/* name must be used in the macros, in the parameter outlib= */
libname mylib  "/prj/arb/nhefs/progs/userguide_examples/Example3";


/*  the user must include the programs mixtran_macro_v1.1.sas and distrib_macro_v1.1.sas */
%include "/prj/arb/nhefs/macros4/mixtran_macro_v1.1.sas" ;
%include "/prj/arb/nhefs/macros4/distrib_macro_v1.1.sas" ;
**************************************************************;   


proc format;
value nonzerof
              0 = '0'
  0.000001-1000 = '  > 0 ';
value agegf
      1 ='  1-3'
      2 ='  4-8'
      3 =' 9-13'
      4 ='14-18'
      5 ='19-30'
      6 ='31-50'
      7 ='51-70'
      8 =' 71+'
      9 =' 19+'
      30=' 9-13'
      40='14-18'
      50='19-30'
      60='31-50'
      70='51-70'
      80=' 71+'
      90=' 19+'
      100='  1+'
      ;

** read in and process the test data;
proc sort data=indata.t_0104nc_may7 out=t_0104nc ;
  by  seqn;
  run;

/* read in data and create dummies of analysis variables ; */
data nhanes;
  set t_0104nc(keep=seqn race rndw rndw1 drxtnumf drddaycd add_sug riagendr ridageyr agegrp stra wkend);
by seqn ;

  * subset to correct age and sex;
  if agegrp>0; 
    
  * eliminate fasters;
  if drxtnumf>0;

  r_add_sug  = ( add_sug  >0 );
  /* seq2 equals 1 if second day of recall and equals 0 otherwise */
  seq2    = (drddaycd    =2 ); 
  sex       = (riagendr    =2 );
  weekend=wkend;
  race1=(race  = 1);
  race3=(race  = 3);
  run;
  
/* in this example, the MIXTRAN macro model type will be "amount".  We will     */
/* recode consumption values of 0 to half the smallest amount actually consumed */
proc freq data=nhanes;
  tables r_add_sug*add_sug/missing list;
  format add_sug nonzerof.;
  title4 'Check zero consumption before replacing zero consumption with half of the minimum amount on a consumption day';
  run;

proc means data=nhanes N NMISS MIN ;
  where r_add_sug;
  var add_sug;
  output min=minadd_sug out=min_add_sug;
  title4 'Calculate the minimum amount on a consumption day';
  run;

data nhanes;
  set nhanes;
  if _n_=1 then set min_add_sug(keep=minadd_sug);
  if add_sug=0 then add_sug=(minadd_sug*0.5);
  run;

** preliminary freqs;
proc freq data=nhanes;
  tables race1*race3*race r_add_sug*add_sug seq2*drddaycd agegrp weekend*wkend stra/missing list;
  format add_sug nonzerof. agegrp agegf.;
  title4 'Preliminary frequencies';
  run;

** data set to be used in the macro analysis ;
data child male female;
  set nhanes;
    
    /** As agegrp is the subgroup variable, its components must be included as covariates **/
    agegrp1=(agegrp=1);
    agegrp2=(agegrp=2);
    agegrp3=(agegrp=3);
    agegrp4=(agegrp=4);
    agegrp5=(agegrp=5);
    agegrp6=(agegrp=6);
    agegrp7=(agegrp=7);
    agegrp8=(agegrp=8);
    if stra=1 then output child;
    if stra=2 then output male;
    if stra=3 then do ;
      agegrp=agegrp*10;
      output female;
    end;
 
  run;
/* run the MIXTRAN macro 3 times, once for each sub-population */

 /* child data with weight, weekend and subgroup */
 
title4 "Output from the MIXTRAN macro for children age 1-8";

%mixtran (data=child,response=add_sug,foodtype=add_sug_child,subject=seqn,
          repeat=drddaycd,covars_prob=,
          covars_amt=agegrp2 race1 race3 sex,
          outlib=mylib,modeltype=amount,lambda=,replicate_var=rndw1,
          seq=seq2,weekend=weekend,vargroup=,numvargroups=,
          subgroup=agegrp,start_val1=,start_val2=, start_val3=,  
          vcontrol=,nloptions= qmax=61,titles=4,printlevel=2);                
run;

 /* male data with weight, weekend and subgroup */
 
title4 "Output from the MIXTRAN macro for males age 9+";

%mixtran (data=male,response=add_sug,foodtype=add_sug_male,subject=seqn,
          repeat=drddaycd,covars_prob=,
          covars_amt=agegrp4 agegrp5 agegrp6 agegrp7 agegrp8 race1 race3,
          outlib=mylib,modeltype=amount,lambda=,replicate_var=rndw1,
          seq=seq2,weekend=weekend,vargroup=,numvargroups=,
          subgroup=agegrp,start_val1=,start_val2=, start_val3=,  
          vcontrol=,nloptions= qmax=61,titles=4,printlevel=2);                
run;

 /* female data with weight, weekend and subgroup */
 
title4 "Output from the MIXTRAN macro for females age 9+";

%mixtran (data=female,response=add_sug,foodtype=add_sug_female,subject=seqn,
          repeat=drddaycd,covars_prob=,
          covars_amt=agegrp4 agegrp5 agegrp6 agegrp7 agegrp8 race1 race3,
          outlib=mylib,modeltype=amount,lambda=,replicate_var=rndw1,
          seq=seq2,weekend=weekend,vargroup=,numvargroups=,
          subgroup=agegrp,start_val1=,start_val2=, start_val3=,  
          vcontrol=,nloptions= qmax=61,titles=4,printlevel=2);                
run;


/* concatenate the data from MIXTRAN to get distributions for all sub-populations at once */

data _pred_unc_add_sug_all;
  set mylib._pred_unc_add_sug_child (in=in1)
      mylib._pred_unc_add_sug_male (in=in2)
      mylib._pred_unc_add_sug_female (in=in3);

       if (in1) then stra = 1;
  else if (in2) then stra = 2;
  else if (in3) then stra = 3;
  run;

data _param_unc_add_sug_all;
  set mylib._param_unc_add_sug_child (in=in1)
      mylib._param_unc_add_sug_male (in=in2)
      mylib._param_unc_add_sug_female (in=in3);

       if (in1) then stra = 1;
  else if (in2) then stra = 2;
  else if (in3) then stra = 3;
  run;


 /* all by-groups combined. */

title4 "Output from the DISTRIB macro for combined sex and age groups";
 
%Distrib (seed=71539741, nsim_mc=100,modeltype=amount,                             
          pred=_pred_unc_add_sug_all, param=_param_unc_add_sug_all,outlib=mylib,
	      cutpoints= 10 12 14 17 22 25 33 38 42 47, 
	      ncutpnt=10,
	      subgroup=agegrp,byvar=stra,subject=seqn,titles=4,food=add_sug_all);
run;

/************************************************************************************/

/* this next step shows how to re-use the data from MIXTRAN */

  /* males aged 19+ */
data _pred_unc_add_sug_m19 ;         
  set mylib._pred_unc_add_sug_male ;
    if agegrp in (5 6 7 8 ) ;
    stra=2;
    run;

data _param_unc_add_sug_m19 ;         
  set mylib._param_unc_add_sug_male ;
  stra=2 ;
  run;
 
title4 "Output from the DISTRIB macro for males age 19+";


%Distrib (seed=5454768, nsim_mc=100,modeltype=amount,                             
          pred=_pred_unc_add_sug_m19, param=_param_unc_add_sug_m19,
          outlib=mylib,
	  cutpoints= 10 12 14 17 22 25 33 38 42 47, 
	  ncutpnt=10,
	  subgroup=,byvar=stra,subject=seqn,titles=4,food=add_sug_m19);
run;    

 
  /* females aged 19+ */
data _pred_unc_add_sug_f19 ;         
  set mylib._pred_unc_add_sug_female ;
  if agegrp in (50 60 70 80 ) ;
  stra=3;
  run;

data _param_unc_add_sug_f19 ;         
  set mylib._param_unc_add_sug_female ;
  stra=3 ;
  run;  

title4 "Output from the DISTRIB macro for females age 19+";

%Distrib (seed=80839153, nsim_mc=100,modeltype=amount,                             
          pred=_pred_unc_add_sug_f19, param=_param_unc_add_sug_f19,
          outlib=mylib,
	  cutpoints= 10 12 14 17 22 25 33 38 42 47, 
	  ncutpnt=10,
	  subgroup=,byvar=stra,subject=seqn,titles=4,food=add_sug_f19);
run;    

  