/*
DSQ Interviewer-Administered Questionnaire
SAS program to process interview-administered questionnaire - as used in NHANES 2009-2010 survey  
*/


 
filename yourdata '**insert file name for data**';



/*
  The following files are contained within the archive that 
  contained this analysis program.  Once extracted from the archive, 
  these files should be located in the same folder/directory as 
  the analysis program.
*/  

filename ntile './cereal.attributes.by.foodcode.xls';
filename af './portion.size.xls'; 
filename ce './regression.coefficients.xls'; 


proc format;  
  value gender 1='male'
               2='female';
  value agecut 1='2 - 17'
               2='>= 18'
	       3='2-11'
	       4='12-17';
run;

data dtq;
  set yourdata;

/*this program uses variables names used in the NHANES 2009-2010 public use data including:
     RIDAGEYR
     RIAGENDR
     DTD010Q--DTQ260U
     dtd020af dtd020bf
     dtdcer
*/

/*in this data step, assign NHANES variable names to variable names required by this program. 
  Required names include: ageinyr (age in years) gender (1=male 2=female)  
  and the food ffq - each food has two variables, times and units 
*/


  ageinyr=RIDAGEYR;
  gender=RIAGENDR;

/*converting responses into times per day for food variables of interest:
*/


  %macro xpd (qvar,uvar,outv,maxv);
    if (0 <= &qvar <= 99) then do;
    if &qvar=0 then &outv=0;
      else if &uvar=1 then &outv=&qvar;
      else if &uvar=2 then &outv=&qvar/7;
      else if &uvar=3 then &outv=&qvar/30;
    end;
    *remove outliers;
    if &outv > &maxv then &outv=.;
  %mend;

  %xpd(DTD010Q,DTQ010U,hccerxpd,7);
  %xpd(DTD030Q,DTQ030U,milkxpd,10);
  %xpd(DTD040Q,DTQ040U,sodaxpd,8);
  %xpd(DTD050Q,DTQ050U,frtjcxpd,8);
  %xpd(DTD060Q,DTQ060U,swtctxpd,10);
  %xpd(DTD070Q,DTQ070U,energyxpd,7);
  %xpd(DTD080Q,DTQ080U,fruitxpd,8);
  %xpd(DTD090Q,DTQ090U,saladxpd,5);
  %xpd(DTD100Q,DTQ100U,frfryxpd,5);
  %xpd(DTD110Q,DTQ110U,othpotxpd,3);
  %xpd(DTD120Q,DTQ120U,beanxpd,4);
  %xpd(DTD130Q,DTQ130U,othvegxpd,5);
  %xpd(DTD140Q,DTQ140U,pizzaxpd,2);
  %xpd(DTD150Q,DTQ150U,salsaxpd,3);
  %xpd(DTD160Q,DTQ160U,tomscxpd,2);
  %xpd(DTD170Q,DTQ170U,redmtxpd,6);
  %xpd(DTD180Q,DTQ180U,procmtxpd,4);
  %xpd(DTD190Q,DTQ190U,cheesexpd,6);
  %xpd(DTD200Q,DTQ200U,whgbrdxpd,6);
  %xpd(DTD210Q,DTQ210U,brricexpd,4);
  %xpd(DTD220Q,DTQ220U,candyxpd,8);
  %xpd(DTD230Q,DTQ230U,donutxpd,5);
  %xpd(DTD240Q,DTQ240U,cakexpd,7);
  %xpd(DTD250Q,DTQ250U,icecrmxpd,5);
  %xpd(DTD260Q,DTQ260U,popcornxpd,3);

  label hccerxpd='number of times per day eat hot or cold cereal'
        milkxpd='number of times per day drink milk'
	sodaxpd='number of times per day drink soda'
	frtjcxpd='number of times per day drink fruit juice'
	swtctxpd='number of times per day drink sweet coffee/tea'
	energyxpd='number of times per day drink fruit/sports/energy drink'
	fruitxpd='number of times per day eat fruit'
	saladxpd='number of times per day eat salad'
	frfryxpd='number of times per day eat fried potatoes'
	othpotxpd='number of times per day eat other potatoes'
	beanxpd='number of times per day eat beans'
	othvegxpd='number of times per day eat other vegetables'
	pizzaxpd='number of times per day eat pizza'
	salsaxpd='number of times per day eat salsa'
	tomscxpd='number of times per day eat tomtato sauce'
	redmtxpd='number of times per day eat red meat'
	procmtxpd='number of times per day eat processed meat'
	cheesexpd='number of times per day eat cheese'
	whgbrdxpd='number of times per day eat whole grain bread'
	brricexpd='number of times per day eat cooked whole grain (brown rice)'
	candyxpd='number of times per day eat candy'
	donutxpd='number of times per day eat pastries'
	cakexpd='number of times per day eat cookies/cake'
	icecrmxpd='number of times per day eat ice cream'
	popcornxpd='number of times per day eat pop corn';


  IF (2 <= ageinyr <= 3) THEN AGEGRP=1;                                           
    ELSE IF (4 <= ageinyr <= 5) THEN AGEGRP=2;
    ELSE IF (6 <= ageinyr <= 7) THEN AGEGRP=3;                                    
    ELSE IF (8 <= ageinyr <= 9) THEN AGEGRP=4;                                    
    ELSE IF (10 <= ageinyr <= 11) THEN AGEGRP=5;                                    
    ELSE IF (12 <= ageinyr <= 13) THEN AGEGRP=6;                                    
    ELSE IF (14 <= ageinyr <= 15) THEN AGEGRP=7;                                    
    ELSE IF (16 <= ageinyr <= 17) THEN AGEGRP=8; 
    ELSE IF (18 <= ageinyr <= 27) THEN AGEGRP=9;                                        
    ELSE IF (28 <= ageinyr <= 37) THEN AGEGRP=10;                                   
    ELSE IF (38 <= ageinyr <= 47) THEN AGEGRP=11;                                    
    ELSE IF (48 <= ageinyr <= 57) THEN AGEGRP=12;                                    
    ELSE IF (58 <= ageinyr <= 67) THEN AGEGRP=13;                                   
    ELSE IF (68 <= ageinyr <= 77) THEN AGEGRP=14;                                   
    ELSE IF ageinyr >= 78 THEN AGEGRP=15;


/*code for 3 age groups 2-11, 12-17, 18+
*/
  if (1 <= agegrp <= 5) then agecut=3;
    else if (6 <= agegrp <= 8) then agecut=4;
    else if (9 <= agegrp <= 15) then agecut=2;
  if agecut=3 then swtctxpd=0;   
run;

proc import datafile=ntile
  out=ntile
  dbms=xls
  replace;
  getnames=yes;
run;	 


proc sort data=ntile;
  by food_code;
run;

data ntile (keep=dtd020af dtd020bf hotcold whgnt sugnt calcnt fibnt);
  set ntile;
  by food_code;
  if first.food_code;
  dtd020af=food_code;
  dtd020bf=food_code;
run;
  
proc sort data=dtq;
  by dtd020af;
run;

proc sort data=ntile;
  by dtd020af;
run;


data dtq (drop= hotcold whgnt sugnt calcnt fibnt);
  merge dtq (in=d) ntile (drop=dtd020bf);
  by dtd020af;
  if d;

  c1hotcold=hotcold;
  c1whgnt=whgnt;
  c1sugnt=sugnt;
  c1calcnt=calcnt;
  c1fibnt=fibnt;
run;

proc sort data=dtq;
  by dtd020bf;
run;

proc sort data=ntile;
  by dtd020bf;
run;

data dtq (drop= hotcold whgnt sugnt calcnt fibnt);
  merge dtq (in=d) ntile (drop=dtd020af);
  by dtd020bf;
  if d;

  c2hotcold=hotcold;
  c2whgnt=whgnt;
  c2sugnt=sugnt;
  c2calcnt=calcnt;
  c2fibnt=fibnt;
run;


data dtq;
  set dtq;

  if dtdcer in (0,1,2) and hccerxpd >= 0 then do;
  hwg1f=0; hwg2f=0; cwg1f=0; cwg2f=0; cwg3f=0; cwg4f=0;
  has1f=0; has2f=0; cas1f=0; cas2f=0; cas3f=0; cas4f=0;
  hcm1f=0; hcm2f=0; hcm3f=0; ccm1f=0; ccm2f=0; ccm3f=0; ccm4f=0;
  hfb1f=0; hfb2f=0; hfb3f=0; cfb1f=0; cfb2f=0; cfb3f=0; cfb4f=0;
  if numcer=1 then do;
    if c1hotcold=2 and c1whgnt=1 then cwg1f=cwg1f+hccerxpd;
      else if c1hotcold=2 and c1whgnt=2 then cwg2f=cwg2f+hccerxpd;
      else if c1hotcold=2 and c1whgnt=3 then cwg3f=cwg3f+hccerxpd;
      else if c1hotcold=2 and c1whgnt=4 then cwg4f=cwg4f+hccerxpd;
      else if c1hotcold=1 and c1whgnt=1 then hwg1f=hwg1f+hccerxpd;
      else if c1hotcold=1 and c1whgnt=2 then hwg2f=hwg2f+hccerxpd;
    if c1hotcold=2 and c1sugnt=1 then cas1f=cas1f+hccerxpd;
      else if c1hotcold=2 and c1sugnt=2 then cas2f=cas2f+hccerxpd;
      else if c1hotcold=2 and c1sugnt=3 then cas3f=cas3f+hccerxpd;
      else if c1hotcold=2 and c1sugnt=4 then cas4f=cas4f+hccerxpd;
      else if c1hotcold=1 and c1sugnt=1 then has1f=has1f+hccerxpd;
      else if c1hotcold=1 and c1sugnt=2 then has2f=has2f+hccerxpd;
    if c1hotcold=2 and c1calcnt=1 then ccm1f=ccm1f+hccerxpd;
      else if c1hotcold=2 and c1calcnt=2 then ccm2f=ccm2f+hccerxpd;
      else if c1hotcold=2 and c1calcnt=3 then ccm3f=ccm3f+hccerxpd;
      else if c1hotcold=2 and c1calcnt=4 then ccm4f=ccm4f+hccerxpd;
      else if c1hotcold=1 and c1calcnt=1 then hcm1f=hcm1f+hccerxpd;
      else if c1hotcold=1 and c1calcnt=2 then hcm2f=hcm2f+hccerxpd;
      else if c1hotcold=1 and c1calcnt=3 then hcm3f=hcm3f+hccerxpd;
    if c1hotcold=2 and c1fibnt=1 then cfb1f=cfb1f+hccerxpd;
      else if c1hotcold=2 and c1fibnt=2 then cfb2f=cfb2f+hccerxpd;
      else if c1hotcold=2 and c1fibnt=3 then cfb3f=cfb3f+hccerxpd;
      else if c1hotcold=2 and c1fibnt=4 then cfb4f=cfb4f+hccerxpd;
      else if c1hotcold=1 and c1fibnt=1 then hfb1f=hfb1f+hccerxpd;
      else if c1hotcold=1 and c1fibnt=2 then hfb2f=hfb2f+hccerxpd;
      else if c1hotcold=1 and c1fibnt=3 then hfb3f=hfb3f+hccerxpd;
   end;
   else if numcer=2 then do;
    if c1hotcold=2 and c1whgnt=1 then cwg1f=cwg1f+(.75*hccerxpd);
      else if c1hotcold=2 and c1whgnt=2 then cwg2f=cwg2f+(.75*hccerxpd);
      else if c1hotcold=2 and c1whgnt=3 then cwg3f=cwg3f+(.75*hccerxpd);
      else if c1hotcold=2 and c1whgnt=4 then cwg4f=cwg4f+(.75*hccerxpd);
      else if c1hotcold=1 and c1whgnt=1 then hwg1f=hwg1f+(.75*hccerxpd);
      else if c1hotcold=1 and c1whgnt=2 then hwg2f=hwg2f+(.75*hccerxpd);
    if c2hotcold=2 and c2whgnt=1 then cwg1f=cwg1f+(.25*hccerxpd);
      else if c2hotcold=2 and c2whgnt=2 then cwg2f=cwg2f+(.25*hccerxpd);
      else if c2hotcold=2 and c2whgnt=3 then cwg3f=cwg3f+(.25*hccerxpd);
      else if c2hotcold=2 and c2whgnt=4 then cwg4f=cwg4f+(.25*hccerxpd);
      else if c2hotcold=1 and c2whgnt=1 then hwg1f=hwg1f+(.25*hccerxpd);
      else if c2hotcold=1 and c2whgnt=2 then hwg2f=hwg2f+(.25*hccerxpd);
    if c1hotcold=2 and c1sugnt=1 then cas1f=cas1f+(.75*hccerxpd);
      else if c1hotcold=2 and c1sugnt=2 then cas2f=cas2f+(.75*hccerxpd);
      else if c1hotcold=2 and c1sugnt=3 then cas3f=cas3f+(.75*hccerxpd);
      else if c1hotcold=2 and c1sugnt=4 then cas4f=cas4f+(.75*hccerxpd);
      else if c1hotcold=1 and c1sugnt=1 then has1f=has1f+(.75*hccerxpd);
      else if c1hotcold=1 and c1sugnt=2 then has2f=has2f+(.75*hccerxpd);
    if c2hotcold=2 and c2sugnt=1 then cas1f=cas1f+(.25*hccerxpd);
      else if c2hotcold=2 and c2sugnt=2 then cas2f=cas2f+(.25*hccerxpd);
      else if c2hotcold=2 and c2sugnt=3 then cas3f=cas3f+(.25*hccerxpd);
      else if c2hotcold=2 and c2sugnt=4 then cas4f=cas4f+(.25*hccerxpd);
      else if c2hotcold=1 and c2sugnt=1 then has1f=has1f+(.25*hccerxpd);
      else if c2hotcold=1 and c2sugnt=2 then has2f=has2f+(.25*hccerxpd);
    if c1hotcold=2 and c1calcnt=1 then ccm1f=ccm1f+(.75*hccerxpd);
      else if c1hotcold=2 and c1calcnt=2 then ccm2f=ccm2f+(.75*hccerxpd);
      else if c1hotcold=2 and c1calcnt=3 then ccm3f=ccm3f+(.75*hccerxpd);
      else if c1hotcold=2 and c1calcnt=4 then ccm4f=ccm4f+(.75*hccerxpd);
      else if c1hotcold=1 and c1calcnt=1 then hcm1f=hcm1f+(.75*hccerxpd);
      else if c1hotcold=1 and c1calcnt=2 then hcm2f=hcm2f+(.75*hccerxpd);
      else if c1hotcold=1 and c1calcnt=3 then hcm3f=hcm3f+(.75*hccerxpd);
    if c2hotcold=2 and c2calcnt=1 then ccm1f=ccm1f+(.25*hccerxpd);
      else if c2hotcold=2 and c2calcnt=2 then ccm2f=ccm2f+(.25*hccerxpd);
      else if c2hotcold=2 and c2calcnt=3 then ccm3f=ccm3f+(.25*hccerxpd);
      else if c2hotcold=2 and c2calcnt=4 then ccm4f=ccm4f+(.25*hccerxpd);
      else if c2hotcold=1 and c2calcnt=1 then hcm1f=hcm1f+(.25*hccerxpd);
      else if c2hotcold=1 and c2calcnt=2 then hcm2f=hcm2f+(.25*hccerxpd);
      else if c2hotcold=1 and c2calcnt=3 then hcm3f=hcm3f+(.25*hccerxpd);
    if c1hotcold=2 and c1fibnt=1 then cfb1f=cfb1f+(.75*hccerxpd);
      else if c1hotcold=2 and c1fibnt=2 then cfb2f=cfb2f+(.75*hccerxpd);
      else if c1hotcold=2 and c1fibnt=3 then cfb3f=cfb3f+(.75*hccerxpd);
      else if c1hotcold=2 and c1fibnt=4 then cfb4f=cfb4f+(.75*hccerxpd);
      else if c1hotcold=1 and c1fibnt=1 then hfb1f=hfb1f+(.75*hccerxpd);
      else if c1hotcold=1 and c1fibnt=2 then hfb2f=hfb2f+(.75*hccerxpd);
      else if c1hotcold=1 and c1fibnt=3 then hfb3f=hfb3f+(.75*hccerxpd);
    if c2hotcold=2 and c2fibnt=1 then cfb1f=cfb1f+(.25*hccerxpd);
      else if c2hotcold=2 and c2fibnt=2 then cfb2f=cfb2f+(.25*hccerxpd);
      else if c2hotcold=2 and c2fibnt=3 then cfb3f=cfb3f+(.25*hccerxpd);
      else if c2hotcold=2 and c2fibnt=4 then cfb4f=cfb4f+(.25*hccerxpd);
      else if c2hotcold=1 and c2fibnt=1 then hfb1f=hfb1f+(.25*hccerxpd);
      else if c2hotcold=1 and c2fibnt=2 then hfb2f=hfb2f+(.25*hccerxpd);
      else if c2hotcold=1 and c2fibnt=3 then hfb3f=hfb3f+(.25*hccerxpd);
    end;
   end;
run;

proc sort data=dtq;
  by gender AGEGRP;
run;

proc import datafile=af
  out=af
  dbms=xls
  replace;
  getnames=yes;
run;	 

proc sort data=af;
  by gender agegrp; 
run;

data dtq;
  merge dtq (in=d) af;
  by gender agegrp;
  if d;
run;

data dtq;
  set dtq;

  ghcerfib1=hfb1f*gP50hcereal;
  ghcerfib2=hfb2f*gP50hcereal;
  ghcerfib3=hfb3f*gP50hcereal;
  gccerfib1=cfb1f*gP50ccereal;
  gccerfib2=cfb2f*gP50ccereal;
  gccerfib3=cfb3f*gP50ccereal;
  gccerfib4=cfb4f*gP50ccereal;
  gwhgbrd=whgbrdxpd*gP50whgrd;
  gpopcorn=popcornxpd*gP50popcorn;
  gbrownrice=brricexpd*gP50brownrice;
  gcheese=cheesexpd*gP50cheese;
  gpizza=pizzaxpd*gP50pizza;
  gmilk=milkxpd*gP50milk;
  gicecream=icecrmxpd*gP50icecream;
  gregsoda=sodaxpd*gP50regsoda;
  gsportfrdrnk=energyxpd*gP50sportfrdrnk;
  gcookietc=cakexpd*gP50cookietc;
  gdonut=donutxpd*gP50donut;
  gsugincof=swtctxpd*gP50sugincof;
  gcandy=candyxpd*gP50candy;
  gfrtj=frtjcxpd*gP50frtj;
  gfruit=fruitxpd*gP50fruit;
  gsalad=saladxpd*gP50salad;
  gothpot=othpotxpd*gP50othpot;
  gdrbean=beanxpd*gP50drbean;
  gothveg=othvegxpd*gP50othveg;
  gfrfry=frfryxpd*gP50frfry;
  gtomsc=tomscxpd*gP50tomsc;
  gsalsa=salsaxpd*gP50salsa;  

  ghcercalc1=hcm1f*gP50hcereal;
  ghcercalc2=hcm2f*gP50hcereal;
  ghcercalc3=hcm3f*gP50hcereal;
  gccercalc1=ccm1f*gP50ccereal;
  gccercalc2=ccm2f*gP50ccereal;
  gccercalc3=ccm3f*gP50ccereal;
  gccercalc4=ccm4f*gP50ccereal;

  shceraddsug1=has1f*sP50hcereal;
  shceraddsug2=has2f*sP50hcereal;
  scceraddsug1=cas1f*sP50ccereal;
  scceraddsug2=cas2f*sP50ccereal;
  scceraddsug3=cas3f*sP50ccereal;
  scceraddsug4=cas4f*sP50ccereal;
  sicecream=icecrmxpd*sP50icecream;
  sregsoda=sodaxpd*sP50regsoda;
  ssportfrdrnk=energyxpd*sP50sportfrdrnk;
  scookietc=cakexpd*sP50cookietc;
  sdonut=donutxpd*sP50donut;
  ssugincof=swtctxpd*sP50sugincof;
  scandy=candyxpd*sP50candy;  

  ghcerwg1=hwg1f*gP50hcereal;
  ghcerwg2=hwg2f*gP50hcereal;
  gccerwg1=cwg1f*gP50ccereal;
  gccerwg2=cwg2f*gP50ccereal;
  gccerwg3=cwg3f*gP50ccereal;
  gccerwg4=cwg4f*gP50ccereal;

  dcheese=cheesexpd*dP50cheese;
  dpizza=pizzaxpd*dP50pizza;
  dmilk=milkxpd*dP50milk;
  dicecream=icecrmxpd*dP50icecream;

  vFRTJ=frtjcxpd*vP50FRTJ;
  vFRUIT=fruitxpd*vP50FRUIT;
  vSALAD=saladxpd*vP50SALAD;
  vOTHPOT=othpotxpd*vP50OTHPOT;
  vDRBEAN=beanxpd*vP50DRBEAN;
  vOTHVEG=othvegxpd*vP50OTHVEG;
  vFRFRY=frfryxpd*vP50FRFRY;
  vTOMSC=tomscxpd*vP50TOMSC;
  vSALSA=salsaxpd*vP50SALSA;
  vPIZZA=pizzaxpd*vP50PIZZA;

/*sum variables then transform
*/
  fd8sug=shceraddsug1+shceraddsug2+scceraddsug1+scceraddsug2+scceraddsug3+scceraddsug4+sicecream+
     sregsoda+ssportfrdrnk+scookietc+sdonut+ssugincof+scandy;
  fd7sug=sregsoda+ssportfrdrnk+scookietc+sdonut+sicecream+ssugincof+scandy;
  btfd8sug=(fd8sug)**.33;
  btfd7sug=(fd7sug)**.33;

  fd10FVL=vFRTJ+vFRUIT+vSALAD+vOTHPOT+vDRBEAN+vOTHVEG+vFRFRY+vTOMSC+vSALSA+vPIZZA;
  fd9FVL=vFRTJ+vFRUIT+vSALAD+vOTHPOT+vDRBEAN+vOTHVEG+vTOMSC+vSALSA+vPIZZA;
  sqrtfd10fvl=sqrt(fd10FVL);
  sqrtfd9fvl=sqrt(fd9FVL);
   
  fd3ssb=sregsoda+ssportfrdrnk+ssugincof;
  sqrtfd3ssb=sqrt(fd3ssb);

  fd4dairy=dcheese+dpizza+dmilk+dicecream;
  sqfd4dairy=sqrt(fd4dairy);

run;

proc sort data=dtq;
  by gender agecut;
run;

proc import datafile=ce
  out=ce
  dbms=xls
  replace;
  getnames=yes;
run;	 

proc sort data=ce;
  by gender agecut;
run;

data dtq;
  merge dtq (in=d) ce;
  by gender agecut;
  if d;
run;

data dtq;
  set dtq;
  by gender agecut;

  predfib=(bintercept +  (ghcerfib1*bghcerfib1) + (ghcerfib2*bghcerfib2) + (ghcerfib3*bghcerfib3) + (gccerfib1*bgccerfib1) +  
     (gccerfib2*bgccerfib2) +  (gccerfib3*bgccerfib3) +  (gccerfib4*bgccerfib4) +  (gwhgbrd*bgwhgbrd) + (gbrownrice*bgbrownrice) + 
     (gcheese*bgcheese) +  (gpizza*bgpizza) +  (gmilk*bgmilk) +  (gicecream*bgicecream) +  (gpopcorn*bgpopcorn) + 
     (gregsoda*bgregsoda) +  (gsportfrdrnk*bgsportfrdrnk) +  (gcookietc*bgcookietc) +  (gdonut*bgdonut) +  (gsugincof*bgsugincof) +  (gcandy*bgcandy) + 
     (gFRTJ*bgfrtj) +  (gFRUIT*bgfruit)  +  (gSALAD*bgsalad) + (gOTHPOT*bgothpot) +  (gDRBEAN*bgdrbean) +
     (gOTHVEG*bgothveg) +  (gFRFRY*bgfrfry) +  (gTOMSC*bgtomsc) +  (gSALSA*bgsalsa) ) ** 4;
  label predfib='daily fiber intake (g)';

  predcalc=(cintercept + (ghcercalc1*cghcercalc1) + (ghcercalc2*cghcercalc2) +  (ghcercalc3*cghcercalc3) +  (gccercalc1*cgccercalc1) +  
     (gccercalc2*cgccercalc2) +  (gccercalc3*cgccercalc3) +  (gccercalc4*cgccercalc4) +  (gwhgbrd*cgwhgbrd) + (gbrownrice*cgbrownrice) + 
     (gcheese*cgcheese) +  (gpizza*cgpizza) +  (gmilk*cgmilk) +  (gicecream*cgicecream) + (gpopcorn*cgpopcorn) +
     (gregsoda*cgregsoda) +  (gsportfrdrnk*cgsportfrdrnk) +  (gcookietc*cgcookietc) +  (gdonut*cgdonut) +  (gsugincof*cgsugincof) +  (gcandy*cgcandy) + 
     (gFRTJ*cgfrtj) +  (gFRUIT*cgfruit) +  (gSALAD*cgsalad) +  (gOTHPOT*cgothpot) +  (gDRBEAN*cgdrbean) +
     (gOTHVEG*cgothveg) +  (gFRFRY*cgfrfry) +  (gTOMSC*cgtomsc) +  (gSALSA*cgsalsa) ) ** 4;
  label predcalc='daily calcium intake (mg)';

  predsug=(wintercept + (wbeta1*btfd8sug ) )**3;
  label predsug='daily added sugar intake (tsp)';

  predwhgrn=(gintercept + (ghcerwg1*gghcerwg1) + (ghcerwg2*gghcerwg2) + (gccerwg1*ggccerwg1) + (gccerwg2*ggccerwg2)
   + (gccerwg3*ggccerwg3) + (gccerwg4*ggccerwg4) + (gwhgbrd*ggwhgbrd) + (gpopcorn*ggpopcorn) + (gbrownrice*ggbrownrice) ) **2;
  label predwhgrn = 'daily whole grain intake (ounce equivalent)';

  preddairy= (dintercept + (dbeta1*sqfd4dairy ) )**2;
  label preddairy = 'daily dairy intake (cup equivalent)';

  predfvl= (vintercept + (vbeta1*sqrtfd10fvl ) )**2;
  label predfvl = 'daily fruit/veg/legume intake (cup)';

  predfvlnf= (nintercept + (nbeta1*sqrtfd9fvl ) )**2;
  label predfvlnf = 'daily fruit/veg/legume minus french fries intake (cup)';

  predssb= (xintercept + (xbeta1*sqrtfd3ssb) ) **2;
  label predssb = 'daily intake of added sugar (tsp) from sugar sweetened beverages';
run;

/*show results of scoring algorithm;
*/
proc means n nmiss min max mean;
  by gender agecut;
  var predfib predcalc predsug predwhgrn preddairy predfvl predfvlnf predssb;
  title2 'predicated intake based on screener responses';
  format gender gender. agecut agecut.;
run;







