
\name{downloadAcclRawData80Hz}
\alias{downloadAcclRawData80Hz}
\title{Raw Physical Activity Monitor (Accelerometer) Data}
\description{
 Download and extract the 2011-2014 NHANES and 2012 NNYFS raw accelerometer data.
}
\usage{ downloadAcclRawData80Hz(destDir, data="NNYFS", subject.seqn="72102", extract=TRUE, 
                                compress=TRUE, zipcmd=NULL, checkForFiles=TRUE,
                                delete.bz2=TRUE, DEBUG=FALSE)
}
\arguments{
  \item{destDir}{Destination folder to download the data. Within \code{destDir}, 
                 a folder will be created with the name of the \code{data}, 
                 and a separate folder for each subject will be created within \code{data}.}
  \item{data}{Name of the data to download \bold{(see details)}. 
              It must be one of "2011-12", "2013-14", or
              "NNYFS". The default is "NNYFS".}
  \item{subject.seqn}{NULL or a vector of SEQN ids to download. SEQN ids for a particular data
                      can be obtained by calling the function \code{\link{getSEQNids}}.
                      This vector can be numeric or character.
                      The default is subject "72102".}
  \item{extract}{TRUE or FALSE to extract the data after it is downloaded.
            The default is TRUE}
  \item{compress}{TRUE or FALSE to compress the data after it is extracted. The default is FALSE.}
  \item{checkForFiles}{TRUE or FALSE to check for the necessary files existing before downloading,
                       extracting, or compressing. If TRUE, then the program will attempt to
                       continue where it left off if a problem occurred from a previous call. 
                       If FALSE, then the program will start from the beginning. The default is TRUE.}
  \item{delete.bz2}{TRUE or FALSE to delete the downloaded .bz2 files when they are no longer needed. 
                    The default is TRUE.}
  \item{zipcmd}{The complete path or command to the 7-zip software. This must be specified for Windows.
                The 7-zip software is the free version of WinZip, and is used for 
                extracting and compressing files on Windows.
                The default is NULL.}
  \item{DEBUG}{TRUE or FALSE. The default is FALSE.}

}
\details{

  \bold{********** WARNING **********} \cr
  The raw accelerometer data is \bold{MASSIVE} in size, so care must be taken when downloading and extracting.
  The compressed sizes are: 
  \tabular{ll}{
    \bold{Data} \tab  \bold{Size}    \cr
    2011-12     \tab  \bold{1.04 TB} \cr
    2013-14     \tab  \bold{1.17 TB} \cr
    NNYFS       \tab  \bold{245 GB} 
  }
  \bold{The uncompressed data will be about 12 times larger than the compressed data.}


  The default values of this function are set to prevent users from accidentally downloading a large amount of data. 


  The raw data is partitioned by subject (SEQN) and is stored in .tar.bz2 files. Each .tar.bz2 file contains several
  csv files, where each csv file is for a particular day. 


  This package has been tested on Unix and Windows operating systems.
}
\value{
  A list containing the SEQN ids for subjects without accelerometer data 
   (\code{missing.data}) and the SEQN ids for subjects where an error
   occurred when downloading that subject's data (\code{error.download}).
}
%\references{}
\examples{
  
  destDir <- "/data/user/NHANES_data/"

  \dontrun{
    downloadAcclRawData80Hz(destDir)
  }
}

%\keyword{ data } 
\seealso{ \code{\link{getSEQNids}}, \code{\link{downloadFiles}} }

