
\name{downloadAndReadFile}
\alias{downloadAndReadFile}
\title{Download a file into a data frame}
\description{
  Download a single (non-raw) data file and return a data frame containing the data
}
\usage{ downloadAndReadFile(data, file, delete=TRUE)
}
\arguments{
  \item{data}{One of "2011-12", "2013-14", or "NNYFS".}
  \item{file}{A single file to download and read. It must be a string from 
               the \code{Name} or \code{File} column in the returned data frame
               from \code{\link{getDataFileInfo}}.
              }
  \item{delete}{TRUE or FALSE to delete the downloaded file after it is read into a data frame.
                   The default is TRUE.}
}
\details{This function will not download the (large) raw accelerometer data. For that,
         the function \code{\link{downloadAcclRawData80Hz}} must be used.
    The file will be downloaded to the working directory (\code{\link{getwd}}).
}

\value{
  A data frame containing the data.
}
%\references{}
\examples{

  \dontrun{
    data1 <- downloadAndReadFile("2011-12", "Tuberculosis")
    data1[1:5, ]
    data2 <- downloadAndReadFile("2013-14", "DXXFRX_H")
    data2[1:5, ]
  }

}
\keyword{ data } 
\seealso{ \code{\link{getDataFileInfo}}, \code{\link{downloadFiles}} }
