
\name{downloadFiles}
\alias{downloadFiles}
\title{Download files}
\description{
  Download (non-raw) data files and save them as a different file type.
}
\usage{ downloadFiles(destDir, data, files=NULL, save.type="csv")
}
\arguments{
  \item{destDir}{Destination folder to download the files.}
  \item{data}{One of "2011-12", "2013-14", or "NNYFS".}
  \item{files}{Character vector of files to download. They must be strings from 
               the \code{Name} or \code{File} columns in the returned data frame
               from \code{\link{getDataFileInfo}}.
               The default is NULL so that all files except the raw accelerometer data
               will be downloaded.
              }
  \item{save.type}{One of "xpt", "csv", or "rda", where "xpt" denotes a SAS transport file,
                   "csv" denotes a comma separated file, and "rda" denotes an R object file
                   that is saved using the \code{\link{save}} function and must be loaded
                   using the \code{\link{load}} function.
                   The default is "csv".}
}
\details{The file names of the saved data will be prefixed with \code{data} and contain 
  the value of the \code{File} column in the data frame from \code{\link{getDataFileInfo}}.

This function will not download the (large) raw accelerometer data. For that,
         the function \code{\link{downloadAcclRawData80Hz}} must be used.
}

\value{
  NULL
}
%\references{}
\examples{

  data <- "NNYFS"

  # Look up all possible files to download
  x <- getDataFileInfo(data)
  x[, 1:2]  

  # Download files "Cardiovascular Fitness", and "Plank" (rows 3 and 11 of above data frame)
  files   <- c("Cardiovascular Fitness", "Y_PLX")
  destDir <- "./" 
  \dontrun{
    downloadFiles(destDir, data, files=files)
  }

}
%\keyword{ data } 
\seealso{ \code{\link{getDataFileInfo}}, \code{\link{downloadAcclRawData80Hz}}, \code{\link{downloadAndReadFile}} }
